<?php

/*
 * This file is part of the Sylius package.
 *
 * (c) Sylius Sp. z o.o.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace Sylius\Component\Shipping\Checker\Rule;

use Sylius\Component\Shipping\Model\ShippingSubjectInterface;

final class TotalWeightLessThanOrEqualRuleChecker implements RuleCheckerInterface
{
    public const TYPE = 'total_weight_less_than_or_equal';

    public function isEligible(ShippingSubjectInterface $subject, array $configuration): bool
    {
        return $subject->getShippingWeight() <= $configuration['weight'];
    }
}
