<?php

/*
 * This file is part of the Sylius package.
 *
 * (c) Sylius Sp. z o.o.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace Sylius\Bundle\ShippingBundle\Form\Type;

use Symfony\Component\Form\FormBuilderInterface;

final class ShippingMethodRuleType extends AbstractConfigurableShippingMethodElementType
{
    public function buildForm(FormBuilderInterface $builder, array $options = []): void
    {
        parent::buildForm($builder, $options);

        $builder
            ->add('type', ShippingMethodRuleChoiceType::class, [
                'label' => 'sylius.form.shipping_method_rule.type',
            ])
        ;
    }

    public function getBlockPrefix(): string
    {
        return 'sylius_shipping_method_rule';
    }
}
