<?php

/*
 * This file is part of the Sylius package.
 *
 * (c) Sylius Sp. z o.o.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace Sylius\Bundle\CoreBundle\CommandHandler\Admin\Account;

use Sylius\Bundle\CoreBundle\Command\Admin\Account\SendResetPasswordEmail;
use Sylius\Bundle\CoreBundle\Mailer\ResetPasswordEmailManagerInterface;
use Sylius\Component\Core\Model\AdminUserInterface;
use Sylius\Component\User\Repository\UserRepositoryInterface;
use Symfony\Component\Messenger\Attribute\AsMessageHandler;
use Webmozart\Assert\Assert;

#[AsMessageHandler]
final class SendResetPasswordEmailHandler
{
    /**
     * @param UserRepositoryInterface<AdminUserInterface> $userRepository
     */
    public function __construct(
        private UserRepositoryInterface $userRepository,
        private ResetPasswordEmailManagerInterface $resetPasswordEmailManager,
    ) {
    }

    public function __invoke(SendResetPasswordEmail $sendResetPasswordEmail): void
    {
        $adminUser = $this->userRepository->findOneByEmail($sendResetPasswordEmail->email);
        Assert::notNull($adminUser);

        $this->resetPasswordEmailManager->sendAdminResetPasswordEmail($adminUser, $sendResetPasswordEmail->localeCode);
    }
}
