@managing_taxons
Feature: Editing taxon's slug
    In order to manage access path to taxon page
    As an Administrator
    I want to be able to edit taxon's slug

    Background:
        Given the store is available in "English (United States)"
        And I am logged in as an administrator

    @api @ui @javascript
    Scenario: Creating a root taxon with an autogenerated slug
        When I want to create a new taxon
        And I specify its code as "MEDIEVAL_WEAPONS"
        And I name it "Medieval weapons" in "English (United States)"
        And I generate its slug in "English (United States)"
        And I add it
        Then this taxon slug should be "medieval-weapons"

    @api @ui
    Scenario: Creating a root taxon with a custom slug
        When I want to create a new taxon
        And I specify its code as "MEDIEVAL_WEAPONS"
        And I name it "Medieval weapons" in "English (United States)"
        And I set its slug to "mw" in "English (United States)"
        And I add it
        Then this taxon slug should be "mw"

    @api @ui @javascript
    Scenario: Creating a child taxon with an autogenerated slug
        Given the store has "Medieval weapons" taxonomy
        When I want to create a new taxon for "Medieval weapons"
        And I specify its code as "SIEGE_ENGINES"
        And I name it "Siege engines" in "English (United States)"
        And I generate its slug in "English (United States)"
        And I add it
        Then this taxon slug should be "medieval-weapons/siege-engines"

    @api @ui @mink:chromedriver
    Scenario: Creating a child taxon with autogenerated slug by setting the parent
        Given the store has "Medieval weapons" taxonomy
        When I want to create a new taxon
        And I specify its code as "PIKES"
        And I name it "Pikes" in "English (United States)"
        And I set its parent taxon to "Medieval weapons"
        And I generate its slug in "English (United States)"
        And I add it
        Then this taxon slug should be "medieval-weapons/pikes"

    @api @ui
    Scenario: Creating a child taxon with a custom slug
        Given the store has "Medieval weapons" taxonomy
        When I want to create a new taxon for "Medieval weapons"
        And I specify its code as "SIEGE_ENGINES"
        And I name it "Siege engines" in "English (United States)"
        And I set its slug to "medieval-weapons/siege" in "English (United States)"
        And I add it
        Then this taxon slug should be "medieval-weapons/siege"

    @api @ui @javascript
    Scenario: Not editing the slug while changing a taxon name
        Given the store has "Medieval weapons" taxonomy
        When I want to modify the "Medieval weapons" taxon
        And I rename it to "Renaissance weapons" in "English (United States)"
        And I save my changes
        Then the slug of the "Renaissance weapons" taxon should still be "medieval-weapons"

    @api @ui @mink:chromedriver
    Scenario: Not editing the slug while setting the taxon's parent
        Given the store has "Medieval weapons" taxonomy
        And the store has "Pikes" taxonomy
        When I want to modify the "Pikes" taxon
        And I set its parent taxon to "Medieval weapons"
        And I save my changes
        Then the slug of the "Pikes" taxon should still be "pikes"

    @api @ui @mink:chromedriver
    Scenario: Not editing the slug while changing the taxon's parent
        Given the store has "Medieval weapons" taxonomy
        And the store has "Renaissance weapons" taxonomy
        And the "Medieval weapons" taxon has child taxon "Pikes"
        When I want to modify the "Pikes" taxon
        And I change its parent taxon to "Renaissance weapons"
        And I save my changes
        Then the slug of the "Pikes" taxon should still be "medieval-weapons/pikes"

    @api @ui @javascript
    Scenario: Generating a root taxon's slug while editing a taxon's name
        Given the store has "Medieval weapons" taxonomy
        When I want to modify the "Medieval weapons" taxon
        And I rename it to "Renaissance weapons" in "English (United States)"
        And I generate its slug in "English (United States)"
        And I save my changes
        Then the slug of the "Renaissance weapons" taxon should be "renaissance-weapons"

    @api @ui @javascript
    Scenario: Generating a child taxon's slug while editing a taxon's name
        Given the store has "Medieval weapons" taxonomy
        And the "Medieval weapons" taxon has child taxon "Pikes"
        When I want to modify the "Pikes" taxon
        And I rename it to "Javelins" in "English (United States)"
        And I generate its slug in "English (United States)"
        And I save my changes
        Then the slug of the "Javelins" taxon should be "medieval-weapons/javelins"

    @api @ui @javascript
    Scenario: Manually changing a root taxon's slug while editing a taxon's name
        Given the store has "Medieval weapons" taxonomy
        When I want to modify the "Medieval weapons" taxon
        And I rename it to "Renaissance weapons" in "English (United States)"
        And I set its slug to "renaissance" in "English (United States)"
        And I save my changes
        Then the slug of the "Renaissance weapons" taxon should be "renaissance"

    @api @ui @mink:chromedriver
    Scenario: Generating a child taxon's slug when changing the parent
        Given the store has "Renaissance weapons" taxonomy
        And the store has "Medieval weapons" taxonomy
        And the "Medieval weapons" taxon has child taxon "Pikes"
        When I want to modify the "Pikes" taxon
        And I change its parent taxon to "Renaissance weapons"
        And I generate its slug in "English (United States)"
        And I save my changes
        Then the slug of the "Pikes" taxon should be "renaissance-weapons/pikes"

    @api @ui @mink:chromedriver
    Scenario: Manually changing a child taxon's slug when changing the parent
        Given the store has "Renaissance weapons" taxonomy
        And the store has "Medieval weapons" taxonomy
        And the "Medieval weapons" taxon has child taxon "Pikes"
        When I want to modify the "Pikes" taxon
        And I change its parent taxon to "Renaissance weapons"
        And I set its slug to "pikes" in "English (United States)"
        And I save my changes
        Then the slug of the "Pikes" taxon should be "pikes"

    @api @ui @javascript
    Scenario: Manually changing a child taxon's slug while editing a taxon's name
        Given the store has "Medieval weapons" taxonomy
        And the "Medieval weapons" taxon has child taxon "Pikes"
        When I want to modify the "Pikes" taxon
        And I rename it to "Javelins" in "English (United States)"
        And I set its slug to "javelins" in "English (United States)"
        And I save my changes
        Then the slug of the "Javelins" taxon should be "javelins"
