@managing_products
Feature: Editing product's slug
    In order to manage access path to product page
    As an Administrator
    I want to be able to edit product's slug

    Background:
        Given the store operates on a single channel in "United States"
        And I am logged in as an administrator

    @api @ui @mink:chromedriver
    Scenario: Creating a product with an autogenerated slug
        When I want to create a new configurable product
        And I specify its code as "BOARD_MANSION_OF_MADNESS"
        And I name it "Mansion of Madness" in "English (United States)" locale
        And I generate its slug in "English (United States)" locale
        And I add it
        Then the slug of the "Mansion of Madness" product should be "mansion-of-madness"

    @api @ui
    Scenario: Creating a product with a custom slug
        When I want to create a new configurable product
        And I specify its code as "BOARD_MANSION_OF_MADNESS"
        And I name it "Mansion of Madness" in "English (United States)" locale
        And I set its slug to "mom-board-game" in "English (United States)" locale
        And I add it
        Then the slug of the "Mansion of Madness" product should be "mom-board-game"

    @api @ui
    Scenario: Prevent from editing a slug while changing a product name
        Given the store has a product "Mansion of Madness"
        When I want to modify this product
        And I rename it to "Mansion of Madness: Second Edition" in "English (United States)" locale
        And I save my changes
        Then the slug of the "Mansion of Madness: Second Edition" product should still be "mansion-of-madness"
