<?php

declare(strict_types=1);

namespace Sylius\SyliusRector\Set;

use Rector\Config\RectorConfig;
use Rector\Renaming\Rector\Name\RenameClassRector;

return static function(RectorConfig $rectorConfig): void {
    $rectorConfig->ruleWithConfiguration(RenameClassRector::class, [
        'Sylius\Plus\Controller\DashboardController' => 'Sylius\MultiStorePlugin\ChannelAdmin\Infrastructure\Controller\DashboardController',
        'Sylius\Plus\Entity\LastLoginIpAwareInterface' => 'Sylius\MultiStorePlugin\ChannelAdmin\Domain\Model\LastLoginIpAwareInterface',
        'Sylius\Plus\Entity\LastLoginIpAwareTrait' => 'Sylius\MultiStorePlugin\ChannelAdmin\Domain\Model\LastLoginIpAwareTrait',
        'Sylius\Plus\Factory\VariantsQuantityMapFactory' => 'Sylius\MultiSourceInventoryPlugin\Application\Factory\VariantsQuantityMapFactory',
        'Sylius\Plus\Factory\VariantsQuantityMapFactoryInterface' => 'Sylius\MultiSourceInventoryPlugin\Application\Factory\VariantsQuantityMapFactoryInterface',
        'Sylius\Plus\Inventory\Infrastructure\Ui\SplitShipmentAction' => 'Sylius\CustomerServicePlugin\PartialShipment\Infrastructure\Ui\Admin\SplitShipmentAction',
        'Sylius\Plus\Inventory\Infrastructure\Validator\StockSufficientForInventorySource' => 'Sylius\MultiSourceInventoryPlugin\Integration\CustomerService\Validator\StockSufficientForInventorySource',
        'Sylius\Plus\Inventory\Infrastructure\Validator\StockSufficientForInventorySourceValidator' => 'Sylius\MultiSourceInventoryPlugin\Integration\CustomerService\Validator\StockSufficientForInventorySourceValidator',
        'Sylius\Plus\Returns\Infrastructure\Ui\Admin\SelectUnitsToReturnToInventoryAction' => 'Sylius\MultiSourceInventoryPlugin\Integration\Return\Ui\Admin\SelectUnitsToReturnToInventoryAction',
        'Sylius\Plus\SharedKernel\Exception\ResourceNotSupportedException' => 'Sylius\SharedKernel\Exception\ResourceNotSupportedException',
        'Sylius\Plus\SharedKernel\ResourceChannelCheckerInterface' => 'Sylius\SharedKernel\Contract\ResourceChannelCheckerInterface',
        // autogenerated mapping
        'Sylius\Plus\Rbac\Tests\Unit\Domain\Model\ToggleablePermissionCheckerTraitTest' => 'Sylius\PlusRbacPlugin\Tests\Unit\Domain\Model\ToggleablePermissionCheckerTraitTest',
        'Sylius\Plus\Rbac\Tests\Unit\Domain\Model\RoleableTraitTest' => 'Sylius\PlusRbacPlugin\Tests\Unit\Domain\Model\RoleableTraitTest',
        'Sylius\Plus\Rbac\Application\Context\AdminUserContextInterface' => 'Sylius\PlusRbacPlugin\Application\Context\AdminUserContextInterface',
        'Sylius\Plus\Rbac\Application\Context\AdminUserContext' => 'Sylius\PlusRbacPlugin\Application\Context\AdminUserContext',
        'Sylius\Plus\Rbac\Application\Cache\Warmer\PrivilegesCacheWarmer' => 'Sylius\PlusRbacPlugin\Application\Cache\Warmer\PrivilegesCacheWarmer',
        'Sylius\Plus\Rbac\Application\Cache\Clearer\PrivilegesCacheClearer' => 'Sylius\PlusRbacPlugin\Application\Cache\Clearer\PrivilegesCacheClearer',
        'Sylius\Plus\Rbac\Application\Privilege\ResourcePrivilege' => 'Sylius\PlusRbacPlugin\Application\Privilege\ResourcePrivilege',
        'Sylius\Plus\Rbac\Application\Privilege\PrivilegeInterface' => 'Sylius\PlusRbacPlugin\Application\Privilege\PrivilegeInterface',
        'Sylius\Plus\Rbac\Application\Privilege\CompositePrivilege' => 'Sylius\PlusRbacPlugin\Application\Privilege\CompositePrivilege',
        'Sylius\Plus\Rbac\Application\Checker\PermissionChecker' => 'Sylius\PlusRbacPlugin\Application\Checker\PermissionChecker',
        'Sylius\Plus\Rbac\Application\Checker\AuthorizationCheckerInterface' => 'Sylius\PlusRbacPlugin\Application\Checker\AuthorizationCheckerInterface',
        'Sylius\Plus\Rbac\Application\Checker\ResourceAuthorizationChecker' => 'Sylius\PlusRbacPlugin\Application\Checker\ResourceAuthorizationChecker',
        'Sylius\Plus\Rbac\Application\Checker\CompositeAuthorizationChecker' => 'Sylius\PlusRbacPlugin\Application\Checker\CompositeAuthorizationChecker',
        'Sylius\Plus\Rbac\Application\Exception\AccessDeniedHttpException' => 'Sylius\PlusRbacPlugin\Application\Exception\AccessDeniedHttpException',
        'Sylius\Plus\Rbac\Application\Exception\PrivilegeArgumentNotImplementedException' => 'Sylius\PlusRbacPlugin\Application\Exception\PrivilegeArgumentNotImplementedException',
        'Sylius\Plus\Rbac\Application\Resolver\AdminPermissionResolver' => 'Sylius\PlusRbacPlugin\Application\Resolver\AdminPermissionResolver',
        'Sylius\Plus\Rbac\Application\Resolver\AdminPermissionResolverInterface' => 'Sylius\PlusRbacPlugin\Application\Resolver\AdminPermissionResolverInterface',
        'Sylius\Plus\Rbac\Infrastructure\Form\Extension\AdminUserTypeExtension' => 'Sylius\PlusRbacPlugin\Infrastructure\Form\Extension\AdminUserTypeExtension',
        'Sylius\Plus\Rbac\Infrastructure\Form\Type\RoleType' => 'Sylius\PlusRbacPlugin\Infrastructure\Form\Type\RoleType',
        'Sylius\Plus\Rbac\Infrastructure\Form\Type\RoleTranslationType' => 'Sylius\PlusRbacPlugin\Infrastructure\Form\Type\RoleTranslationType',
        'Sylius\Plus\Rbac\Infrastructure\Fixture\RoleFixture' => 'Sylius\PlusRbacPlugin\Infrastructure\Fixture\RoleFixture',
        'Sylius\Plus\Rbac\Infrastructure\Fixture\Factory\RoleExampleFactory' => 'Sylius\PlusRbacPlugin\Infrastructure\Fixture\Factory\RoleExampleFactory',
        'Sylius\Plus\Rbac\Infrastructure\Templating\Helper\AclHelper' => 'Sylius\PlusRbacPlugin\Infrastructure\Templating\Helper\AclHelper',
        'Sylius\Plus\Rbac\Infrastructure\Doctrine\ORM\RoleRepositoryInterface' => 'Sylius\PlusRbacPlugin\Infrastructure\Doctrine\ORM\RoleRepositoryInterface',
        'Sylius\Plus\Rbac\Infrastructure\Doctrine\ORM\RoleRepository' => 'Sylius\PlusRbacPlugin\Infrastructure\Doctrine\ORM\RoleRepository',
        'Sylius\Plus\Rbac\Infrastructure\Menu\OrderShowMenuBuilder' => 'Sylius\PlusRbacPlugin\Infrastructure\Menu\OrderShowMenuBuilder',
        'Sylius\Plus\Rbac\Infrastructure\Menu\PermissionExtension' => 'Sylius\PlusRbacPlugin\Infrastructure\Menu\PermissionExtension',
        'Sylius\Plus\Rbac\Infrastructure\Menu\AbstractPermissionChecker' => 'Sylius\PlusRbacPlugin\Infrastructure\Menu\AbstractPermissionChecker',
        'Sylius\Plus\Rbac\Infrastructure\Menu\MainMenuBuilder' => 'Sylius\PlusRbacPlugin\Infrastructure\Menu\MainMenuBuilder',
        'Sylius\Plus\Rbac\Infrastructure\Menu\AdministrationMenuBuilder' => 'Sylius\PlusRbacPlugin\Infrastructure\Menu\AdministrationMenuBuilder',
        'Sylius\Plus\Rbac\Infrastructure\Menu\CustomerShowMenuBuilder' => 'Sylius\PlusRbacPlugin\Infrastructure\Menu\CustomerShowMenuBuilder',
        'Sylius\Plus\Rbac\Infrastructure\Command\DisableAdministratorPermissionCheckerCommand' => 'Sylius\PlusRbacPlugin\Infrastructure\Command\DisableAdministratorPermissionCheckerCommand',
        'Sylius\Plus\Rbac\Infrastructure\Twig\HttpKernelExtension' => 'Sylius\PlusRbacPlugin\Infrastructure\Twig\HttpKernelExtension',
        'Sylius\Plus\Rbac\Infrastructure\Twig\AclExtension' => 'Sylius\PlusRbacPlugin\Infrastructure\Twig\AclExtension',
        'Sylius\Plus\Rbac\Infrastructure\Twig\RoutingExtension' => 'Sylius\PlusRbacPlugin\Infrastructure\Twig\RoutingExtension',
        'Sylius\Plus\Rbac\Infrastructure\EventListener\PermissionCheckerListener' => 'Sylius\PlusRbacPlugin\Infrastructure\EventListener\PermissionCheckerListener',
        'Sylius\Plus\Rbac\Domain\Model\RoleTranslation' => 'Sylius\PlusRbacPlugin\Domain\Model\RoleTranslation',
        'Sylius\Plus\Rbac\Domain\Model\RoleInterface' => 'Sylius\PlusRbacPlugin\Domain\Model\RoleInterface',
        'Sylius\Plus\Rbac\Domain\Model\RoleableInterface' => 'Sylius\PlusRbacPlugin\Domain\Model\RoleableInterface',
        'Sylius\Plus\Rbac\Domain\Model\Role' => 'Sylius\PlusRbacPlugin\Domain\Model\Role',
        'Sylius\Plus\Rbac\Domain\Model\AdminUserInterface' => 'Sylius\PlusRbacPlugin\Domain\Model\AdminUserInterface',
        'Sylius\Plus\Rbac\Domain\Model\RoleableTrait' => 'Sylius\PlusRbacPlugin\Domain\Model\RoleableTrait',
        'Sylius\Plus\Rbac\Domain\Model\RoleTranslationInterface' => 'Sylius\PlusRbacPlugin\Domain\Model\RoleTranslationInterface',
        'Sylius\Plus\Rbac\Domain\Model\ToggleablePermissionCheckerInterface' => 'Sylius\PlusRbacPlugin\Domain\Model\ToggleablePermissionCheckerInterface',
        'Sylius\Plus\Rbac\Domain\Model\ToggleablePermissionCheckerTrait' => 'Sylius\PlusRbacPlugin\Domain\Model\ToggleablePermissionCheckerTrait',
        'Sylius\Plus\Rbac\DependencyInjection\Compiler\CompositeAuthorizationCheckerPass' => 'Sylius\PlusRbacPlugin\DependencyInjection\Compiler\CompositeAuthorizationCheckerPass',
        'Sylius\Plus\Rbac\DependencyInjection\Compiler\RequestMatcherPass' => 'Sylius\PlusRbacPlugin\DependencyInjection\Compiler\RequestMatcherPass',
        'Sylius\Plus\Rbac\DependencyInjection\Compiler\CompositePrivilegePass' => 'Sylius\PlusRbacPlugin\DependencyInjection\Compiler\CompositePrivilegePass',
        'Sylius\Plus\CustomerPools\Tests\Unit\Infrastructure\Form\Extension\CustomerGuestTypeExtensionTest' => 'Sylius\MultiStorePlugin\CustomerPools\Tests\Unit\Infrastructure\Form\Extension\CustomerGuestTypeExtensionTest',
        'Sylius\Plus\CustomerPools\Tests\Unit\Infrastructure\Fixture\CustomerPoolFixtureTest' => 'Sylius\MultiStorePlugin\CustomerPools\Tests\Unit\Infrastructure\Fixture\CustomerPoolFixtureTest',
        'Sylius\Plus\CustomerPools\Tests\Unit\Domain\Model\CustomerPoolAwareTraitTest' => 'Sylius\MultiStorePlugin\CustomerPools\Tests\Unit\Domain\Model\CustomerPoolAwareTraitTest',
        'Sylius\Plus\CustomerPools\Application\CommandHandler\Account\SendAccountVerificationEmailHandler' => 'Sylius\MultiStorePlugin\CustomerPools\Application\CommandHandler\Account\SendAccountVerificationEmailHandler',
        'Sylius\Plus\CustomerPools\Application\CommandHandler\Account\SendAccountRegistrationEmailHandler' => 'Sylius\MultiStorePlugin\CustomerPools\Application\CommandHandler\Account\SendAccountRegistrationEmailHandler',
        'Sylius\Plus\CustomerPools\Application\Context\CustomerPoolNotFoundException' => 'Sylius\MultiStorePlugin\CustomerPools\Application\Context\CustomerPoolNotFoundException',
        'Sylius\Plus\CustomerPools\Application\Context\CustomerPoolContextInterface' => 'Sylius\MultiStorePlugin\CustomerPools\Application\Context\CustomerPoolContextInterface',
        'Sylius\Plus\CustomerPools\Application\Checker\CustomerResourceChannelChecker' => 'Sylius\MultiStorePlugin\CustomerPools\Application\Checker\CustomerResourceChannelChecker',
        'Sylius\Plus\CustomerPools\Application\EventListener\ReviewCreateListener' => 'Sylius\MultiStorePlugin\CustomerPools\Application\EventListener\ReviewCreateListener',
        'Sylius\Plus\CustomerPools\Infrastructure\Form\Extension\CustomerTypeExtension' => 'Sylius\MultiStorePlugin\CustomerPools\Infrastructure\Form\Extension\CustomerTypeExtension',
        'Sylius\Plus\CustomerPools\Infrastructure\Form\Extension\CustomerRegistrationTypeExtension' => 'Sylius\MultiStorePlugin\CustomerPools\Infrastructure\Form\Extension\CustomerRegistrationTypeExtension',
        'Sylius\Plus\CustomerPools\Infrastructure\Form\Extension\ChannelTypeExtension' => 'Sylius\MultiStorePlugin\CustomerPools\Infrastructure\Form\Extension\ChannelTypeExtension',
        'Sylius\Plus\CustomerPools\Infrastructure\Form\Extension\CustomerGuestTypeExtension' => 'Sylius\MultiStorePlugin\CustomerPools\Infrastructure\Form\Extension\CustomerGuestTypeExtension',
        'Sylius\Plus\CustomerPools\Infrastructure\Form\Type\CustomerPoolChoiceType' => 'Sylius\MultiStorePlugin\CustomerPools\Infrastructure\Form\Type\CustomerPoolChoiceType',
        'Sylius\Plus\CustomerPools\Infrastructure\Form\Type\CustomerPoolType' => 'Sylius\MultiStorePlugin\CustomerPools\Infrastructure\Form\Type\CustomerPoolType',
        'Sylius\Plus\CustomerPools\Infrastructure\Context\ChannelBasedCustomerPoolContext' => 'Sylius\MultiStorePlugin\CustomerPools\Infrastructure\Context\ChannelBasedCustomerPoolContext',
        'Sylius\Plus\CustomerPools\Infrastructure\Validator\CustomerClassMetadataLoader' => 'Sylius\MultiStorePlugin\CustomerPools\Infrastructure\Validator\CustomerClassMetadataLoader',
        'Sylius\Plus\CustomerPools\Infrastructure\Validator\RegisteredUserValidator' => 'Sylius\MultiStorePlugin\CustomerPools\Infrastructure\Validator\RegisteredUserValidator',
        'Sylius\Plus\CustomerPools\Infrastructure\Validator\ApiUniqueReviewerEmailValidator' => 'Sylius\MultiStorePlugin\CustomerPools\Infrastructure\Validator\ApiUniqueReviewerEmailValidator',
        'Sylius\Plus\CustomerPools\Infrastructure\Validator\UniqueReviewerEmailValidator' => 'Sylius\MultiStorePlugin\CustomerPools\Infrastructure\Validator\UniqueReviewerEmailValidator',
        'Sylius\Plus\CustomerPools\Infrastructure\Validator\UniqueShopUserEmailValidator' => 'Sylius\MultiStorePlugin\CustomerPools\Infrastructure\Validator\UniqueShopUserEmailValidator',
        'Sylius\Plus\CustomerPools\Infrastructure\Fixture\CustomerPoolFixture' => 'Sylius\MultiStorePlugin\CustomerPools\Infrastructure\Fixture\CustomerPoolFixture',
        'Sylius\Plus\CustomerPools\Infrastructure\Fixture\Factory\CustomerPoolExampleFactory' => 'Sylius\MultiStorePlugin\CustomerPools\Infrastructure\Fixture\Factory\CustomerPoolExampleFactory',
        'Sylius\Plus\CustomerPools\Infrastructure\Provider\CustomerProviderInterface' => 'Sylius\MultiStorePlugin\CustomerPools\Infrastructure\Provider\CustomerProviderInterface',
        'Sylius\Plus\CustomerPools\Infrastructure\Provider\UsernameAndCustomerPoolProvider' => 'Sylius\MultiStorePlugin\CustomerPools\Infrastructure\Provider\UsernameAndCustomerPoolProvider',
        'Sylius\Plus\CustomerPools\Infrastructure\Doctrine\CustomerLoadClassMetadataListener' => 'Sylius\MultiStorePlugin\CustomerPools\Infrastructure\Doctrine\CustomerLoadClassMetadataListener',
        'Sylius\Plus\CustomerPools\Infrastructure\Doctrine\ORM\FindShopUserByUsernameAndCustomerPoolQueryInterface' => 'Sylius\MultiStorePlugin\CustomerPools\Infrastructure\Doctrine\ORM\FindShopUserByUsernameAndCustomerPoolQueryInterface',
        'Sylius\Plus\CustomerPools\Infrastructure\Doctrine\ORM\FindShopUserByUsernameAndCustomerPoolQuery' => 'Sylius\MultiStorePlugin\CustomerPools\Infrastructure\Doctrine\ORM\FindShopUserByUsernameAndCustomerPoolQuery',
        'Sylius\Plus\CustomerPools\Infrastructure\Menu\AdminMenuListener' => 'Sylius\MultiStorePlugin\CustomerPools\Infrastructure\Menu\AdminMenuListener',
        'Sylius\Plus\CustomerPools\Infrastructure\Resolver\CustomerResolverInterface' => 'Sylius\Bundle\CoreBundle\Resolver\CustomerResolverInterface',
        'Sylius\Plus\CustomerPools\Domain\Model\CustomerPoolAwareInterface' => 'Sylius\MultiStorePlugin\CustomerPools\Domain\Model\CustomerPoolAwareInterface',
        'Sylius\Plus\CustomerPools\Domain\Model\CustomerPoolInterface' => 'Sylius\MultiStorePlugin\CustomerPools\Domain\Model\CustomerPoolInterface',
        'Sylius\Plus\CustomerPools\Domain\Model\CustomerPoolAwareTrait' => 'Sylius\MultiStorePlugin\CustomerPools\Domain\Model\CustomerPoolAwareTrait',
        'Sylius\Plus\CustomerPools\Domain\Model\CustomerPool' => 'Sylius\MultiStorePlugin\CustomerPools\Domain\Model\CustomerPool',
        'Sylius\Plus\CustomerPools\Domain\Model\CustomerInterface' => 'Sylius\MultiStorePlugin\CustomerPools\Domain\Model\CustomerInterface',
        'Sylius\Plus\CustomerPools\Domain\Model\ChannelInterface' => 'Sylius\MultiStorePlugin\CustomerPools\Domain\Model\ChannelInterface',
        'Sylius\Plus\BusinessUnits\Tests\Unit\Infrastructure\Fixture\BusinessUnitFixtureTest' => 'Sylius\MultiStorePlugin\BusinessUnits\Tests\Unit\Infrastructure\Fixture\BusinessUnitFixtureTest',
        'Sylius\Plus\BusinessUnits\Tests\Unit\Domain\Model\BusinessUnitAwareTraitTest' => 'Sylius\MultiStorePlugin\BusinessUnits\Tests\Unit\Domain\Model\BusinessUnitAwareTraitTest',
        'Sylius\Plus\BusinessUnits\Infrastructure\Form\Extension\ChannelTypeExtension' => 'Sylius\MultiStorePlugin\BusinessUnits\Infrastructure\Form\Extension\ChannelTypeExtension',
        'Sylius\Plus\BusinessUnits\Infrastructure\Form\Type\BusinessUnitChoiceType' => 'Sylius\MultiStorePlugin\BusinessUnits\Infrastructure\Form\Type\BusinessUnitChoiceType',
        'Sylius\Plus\BusinessUnits\Infrastructure\Form\Type\BusinessUnitAddressType' => 'Sylius\MultiStorePlugin\BusinessUnits\Infrastructure\Form\Type\BusinessUnitAddressType',
        'Sylius\Plus\BusinessUnits\Infrastructure\Form\Type\BusinessUnitType' => 'Sylius\MultiStorePlugin\BusinessUnits\Infrastructure\Form\Type\BusinessUnitType',
        'Sylius\Plus\BusinessUnits\Infrastructure\Fixture\BusinessUnitFixture' => 'Sylius\MultiStorePlugin\BusinessUnits\Infrastructure\Fixture\BusinessUnitFixture',
        'Sylius\Plus\BusinessUnits\Infrastructure\Fixture\Factory\BusinessUnitExampleFactory' => 'Sylius\MultiStorePlugin\BusinessUnits\Infrastructure\Fixture\Factory\BusinessUnitExampleFactory',
        'Sylius\Plus\BusinessUnits\Infrastructure\Fixture\Factory\BusinessUnitAddressExampleFactory' => 'Sylius\MultiStorePlugin\BusinessUnits\Infrastructure\Fixture\Factory\BusinessUnitAddressExampleFactory',
        'Sylius\Plus\BusinessUnits\Infrastructure\Menu\AdminMenuListener' => 'Sylius\MultiStorePlugin\BusinessUnits\Infrastructure\Menu\AdminMenuListener',
        'Sylius\Plus\BusinessUnits\Domain\Model\BusinessUnitAddress' => 'Sylius\MultiStorePlugin\BusinessUnits\Domain\Model\BusinessUnitAddress',
        'Sylius\Plus\BusinessUnits\Domain\Model\BusinessUnitAwareInterface' => 'Sylius\MultiStorePlugin\BusinessUnits\Domain\Model\BusinessUnitAwareInterface',
        'Sylius\Plus\BusinessUnits\Domain\Model\BusinessUnit' => 'Sylius\MultiStorePlugin\BusinessUnits\Domain\Model\BusinessUnit',
        'Sylius\Plus\BusinessUnits\Domain\Model\ChannelInterface' => 'Sylius\MultiStorePlugin\BusinessUnits\Domain\Model\ChannelInterface',
        'Sylius\Plus\BusinessUnits\Domain\Model\BusinessUnitAwareTrait' => 'Sylius\MultiStorePlugin\BusinessUnits\Domain\Model\BusinessUnitAwareTrait',
        'Sylius\Plus\BusinessUnits\Domain\Model\BusinessUnitInterface' => 'Sylius\MultiStorePlugin\BusinessUnits\Domain\Model\BusinessUnitInterface',
        'Sylius\Plus\BusinessUnits\Domain\Model\BusinessUnitAddressInterface' => 'Sylius\MultiStorePlugin\BusinessUnits\Domain\Model\BusinessUnitAddressInterface',
        'Sylius\Plus\Loyalty\Tests\Unit\Infrastructure\Form\Type\Action\ChannelsBasedItemsTotalToPointsRatioConfigurationTypeTest' => 'Sylius\LoyaltyPlugin\Tests\Unit\Infrastructure\Form\Type\Action\ChannelsBasedItemsTotalToPointsRatioConfigurationTypeTest',
        'Sylius\Plus\Loyalty\Tests\Unit\Infrastructure\Form\Type\Action\ChannelsBasedPointsPerProductRatioConfigurationTypeTest' => 'Sylius\LoyaltyPlugin\Tests\Unit\Infrastructure\Form\Type\Action\ChannelsBasedPointsPerProductRatioConfigurationTypeTest',
        'Sylius\Plus\Loyalty\Tests\Unit\Infrastructure\Form\Type\LoyaltyRuleActionTypeTest' => 'Sylius\LoyaltyPlugin\Tests\Unit\Infrastructure\Form\Type\LoyaltyRuleActionTypeTest',
        'Sylius\Plus\Loyalty\Tests\Unit\Infrastructure\Fixture\LoyaltyRuleFixtureTest' => 'Sylius\LoyaltyPlugin\Tests\Unit\Infrastructure\Fixture\LoyaltyRuleFixtureTest',
        'Sylius\Plus\Loyalty\Tests\Unit\Infrastructure\Fixture\LoyaltyPurchaseFixtureTest' => 'Sylius\LoyaltyPlugin\Tests\Unit\Infrastructure\Fixture\LoyaltyPurchaseFixtureTest',
        'Sylius\Plus\Loyalty\Tests\Unit\Domain\Model\LoyaltyAwareTraitTest' => 'Sylius\LoyaltyPlugin\Tests\Unit\Domain\Model\LoyaltyAwareTraitTest',
        'Sylius\Plus\Loyalty\Application\DTO\LoyaltyRuleActionInterface' => 'Sylius\LoyaltyPlugin\Application\DTO\LoyaltyRuleActionInterface',
        'Sylius\Plus\Loyalty\Application\DTO\LoyaltyRuleAction' => 'Sylius\LoyaltyPlugin\Application\DTO\LoyaltyRuleAction',
        'Sylius\Plus\Loyalty\Application\CommandHandler\BuyLoyaltyPurchaseHandler' => 'Sylius\LoyaltyPlugin\Application\CommandHandler\BuyLoyaltyPurchaseHandler',
        'Sylius\Plus\Loyalty\Application\Logger\LoyaltyPointsTransactionLogger' => 'Sylius\LoyaltyPlugin\Application\Logger\LoyaltyPointsTransactionLogger',
        'Sylius\Plus\Loyalty\Application\Logger\LoyaltyPointsTransactionLoggerInterface' => 'Sylius\LoyaltyPlugin\Application\Logger\LoyaltyPointsTransactionLoggerInterface',
        'Sylius\Plus\Loyalty\Application\Calculator\LoyaltyActionTypes' => 'Sylius\LoyaltyPlugin\Application\Calculator\LoyaltyActionTypes',
        'Sylius\Plus\Loyalty\Application\Calculator\ActionBasedLoyaltyPointsCalculatorInterface' => 'Sylius\LoyaltyPlugin\Application\Calculator\ActionBasedLoyaltyPointsCalculatorInterface',
        'Sylius\Plus\Loyalty\Application\Calculator\ConfigurationBasedLoyaltyPointsCalculatorInterface' => 'Sylius\LoyaltyPlugin\Application\Calculator\ConfigurationBasedLoyaltyPointsCalculatorInterface',
        'Sylius\Plus\Loyalty\Application\Calculator\ChannelsBasedItemsTotalToPointsRatioCalculator' => 'Sylius\LoyaltyPlugin\Application\Calculator\ChannelsBasedItemsTotalToPointsRatioCalculator',
        'Sylius\Plus\Loyalty\Application\Calculator\DelegatingLoyaltyPointsCalculator' => 'Sylius\LoyaltyPlugin\Application\Calculator\DelegatingLoyaltyPointsCalculator',
        'Sylius\Plus\Loyalty\Application\Calculator\ChannelsBasedPointsPerProductRatioCalculator' => 'Sylius\LoyaltyPlugin\Application\Calculator\ChannelsBasedPointsPerProductRatioCalculator',
        'Sylius\Plus\Loyalty\Application\Modifier\LoyaltyPointsAccountModifier' => 'Sylius\LoyaltyPlugin\Application\Modifier\LoyaltyPointsAccountModifier',
        'Sylius\Plus\Loyalty\Application\Modifier\LoyaltyPointsAccountModifierInterface' => 'Sylius\LoyaltyPlugin\Application\Modifier\LoyaltyPointsAccountModifierInterface',
        'Sylius\Plus\Loyalty\Application\Processor\LoyaltyPointsProcessor' => 'Sylius\LoyaltyPlugin\Application\Processor\LoyaltyPointsProcessor',
        'Sylius\Plus\Loyalty\Application\Provider\OrdersLoyaltyPointsProvider' => 'Sylius\LoyaltyPlugin\Application\Provider\OrdersLoyaltyPointsProvider',
        'Sylius\Plus\Loyalty\Application\Provider\LoyaltyPointsAccountProvider' => 'Sylius\LoyaltyPlugin\Application\Provider\LoyaltyPointsAccountProvider',
        'Sylius\Plus\Loyalty\Application\Provider\OrdersLoyaltyPointsProviderInterface' => 'Sylius\LoyaltyPlugin\Application\Provider\OrdersLoyaltyPointsProviderInterface',
        'Sylius\Plus\Loyalty\Application\Provider\LoyaltyPointsAccountProviderInterface' => 'Sylius\LoyaltyPlugin\Application\Provider\LoyaltyPointsAccountProviderInterface',
        'Sylius\Plus\Loyalty\Application\Mailer\Emails' => 'Sylius\LoyaltyPlugin\Application\Mailer\Emails',
        'Sylius\Plus\Loyalty\Application\DataProvider\LoyaltyPointsAccountDataProvider' => 'Sylius\LoyaltyPlugin\Application\DataProvider\LoyaltyPointsAccountDataProvider',
        'Sylius\Plus\Loyalty\Application\Generator\LoyaltyPurchasePromotionCouponInstructionGenerator' => 'Sylius\LoyaltyPlugin\Application\Generator\LoyaltyPurchasePromotionCouponInstructionGenerator',
        'Sylius\Plus\Loyalty\Application\Generator\LoyaltyPurchasePromotionCouponInstructionGeneratorInterface' => 'Sylius\LoyaltyPlugin\Application\Generator\LoyaltyPurchasePromotionCouponInstructionGeneratorInterface',
        'Sylius\Plus\Loyalty\Application\Command\CustomerEmailAwareInterface' => 'Sylius\LoyaltyPlugin\Application\Command\CustomerEmailAwareInterface',
        'Sylius\Plus\Loyalty\Application\Command\BuyLoyaltyPurchase' => 'Sylius\LoyaltyPlugin\Application\Command\BuyLoyaltyPurchase',
        'Sylius\Plus\Loyalty\Application\Assigner\LoyaltyPointsAssignerInterface' => 'Sylius\LoyaltyPlugin\Application\Assigner\LoyaltyPointsAssignerInterface',
        'Sylius\Plus\Loyalty\Application\Assigner\LoyaltyPointsAssigner' => 'Sylius\LoyaltyPlugin\Application\Assigner\LoyaltyPointsAssigner',
        'Sylius\Plus\Loyalty\Application\Factory\LoyaltyRuleActionFactoryInterface' => 'Sylius\LoyaltyPlugin\Application\Factory\LoyaltyRuleActionFactoryInterface',
        'Sylius\Plus\Loyalty\Application\Factory\LoyaltyRuleActionFactory' => 'Sylius\LoyaltyPlugin\Application\Factory\LoyaltyRuleActionFactory',
        'Sylius\Plus\Loyalty\Infrastructure\Ui\Shop\BuyLoyaltyPurchaseAction' => 'Sylius\LoyaltyPlugin\Infrastructure\Ui\Shop\BuyLoyaltyPurchaseAction',
        'Sylius\Plus\Loyalty\Infrastructure\Form\DataMapper\ChannelBasedRatioConfigurationDataMapper' => 'Sylius\LoyaltyPlugin\Infrastructure\Form\DataMapper\ChannelBasedRatioConfigurationDataMapper',
        'Sylius\Plus\Loyalty\Infrastructure\Form\DataTransformer\ChangeActionToChannelsBasedRatioConfigurationTransformer' => 'Sylius\LoyaltyPlugin\Infrastructure\Form\DataTransformer\ChangeActionToChannelsBasedRatioConfigurationTransformer',
        'Sylius\Plus\Loyalty\Infrastructure\Form\DataTransformer\NullableIdentifierToResourceTransformer' => 'Sylius\LoyaltyPlugin\Infrastructure\Form\DataTransformer\NullableIdentifierToResourceTransformer',
        'Sylius\Plus\Loyalty\Infrastructure\Form\Type\LoyaltyRuleActionType' => 'Sylius\LoyaltyPlugin\Infrastructure\Form\Type\LoyaltyRuleActionType',
        'Sylius\Plus\Loyalty\Infrastructure\Form\Type\ProductPerChannelAutocompleteChoiceType' => 'Sylius\LoyaltyPlugin\Infrastructure\Form\Type\ProductPerChannelAutocompleteChoiceType',
        'Sylius\Plus\Loyalty\Infrastructure\Form\Type\LoyaltyPurchaseType' => 'Sylius\LoyaltyPlugin\Infrastructure\Form\Type\LoyaltyPurchaseType',
        'Sylius\Plus\Loyalty\Infrastructure\Form\Type\LoyaltyRuleType' => 'Sylius\LoyaltyPlugin\Infrastructure\Form\Type\LoyaltyRuleType',
        'Sylius\Plus\Loyalty\Infrastructure\Form\Type\Action\ChannelsBasedPointsPerProductRatioConfigurationType' => 'Sylius\LoyaltyPlugin\Infrastructure\Form\Type\Action\ChannelsBasedPointsPerProductRatioConfigurationType',
        'Sylius\Plus\Loyalty\Infrastructure\Form\Type\Action\ItemsTotalToPointsRatioConfigurationType' => 'Sylius\LoyaltyPlugin\Infrastructure\Form\Type\Action\ItemsTotalToPointsRatioConfigurationType',
        'Sylius\Plus\Loyalty\Infrastructure\Form\Type\Action\ChannelsBasedItemsTotalToPointsRatioConfigurationType' => 'Sylius\LoyaltyPlugin\Infrastructure\Form\Type\Action\ChannelsBasedItemsTotalToPointsRatioConfigurationType',
        'Sylius\Plus\Loyalty\Infrastructure\Form\Type\Action\PointsPerProductRatioConfigurationType' => 'Sylius\LoyaltyPlugin\Infrastructure\Form\Type\Action\PointsPerProductRatioConfigurationType',
        'Sylius\Plus\Loyalty\Infrastructure\Form\Type\LoyaltyRuleActionTypeChoiceType' => 'Sylius\LoyaltyPlugin\Infrastructure\Form\Type\LoyaltyRuleActionTypeChoiceType',
        'Sylius\Plus\Loyalty\Infrastructure\Form\Type\CouponBasedPromotionChoiceType' => 'Sylius\LoyaltyPlugin\Infrastructure\Form\Type\CouponBasedPromotionChoiceType',
        'Sylius\Plus\Loyalty\Infrastructure\Serializer\OrderNormalizer' => 'Sylius\LoyaltyPlugin\Infrastructure\Serializer\OrderNormalizer',
        'Sylius\Plus\Loyalty\Infrastructure\Serializer\LoyaltyRuleDenormalizer' => 'Sylius\LoyaltyPlugin\Infrastructure\Serializer\LoyaltyRuleDenormalizer',
        'Sylius\Plus\Loyalty\Infrastructure\Validator\PointsPerProductRatioConfigurationEligibility' => 'Sylius\LoyaltyPlugin\Infrastructure\Validator\PointsPerProductRatioConfigurationEligibility',
        'Sylius\Plus\Loyalty\Infrastructure\Validator\RegisteredRuleActionType' => 'Sylius\LoyaltyPlugin\Infrastructure\Validator\RegisteredRuleActionType',
        'Sylius\Plus\Loyalty\Infrastructure\Validator\SufficientPointsForPurchaseValidator' => 'Sylius\LoyaltyPlugin\Infrastructure\Validator\SufficientPointsForPurchaseValidator',
        'Sylius\Plus\Loyalty\Infrastructure\Validator\PromotionEligibilityValidator' => 'Sylius\LoyaltyPlugin\Infrastructure\Validator\PromotionEligibilityValidator',
        'Sylius\Plus\Loyalty\Infrastructure\Validator\RegisteredRuleActionTypeValidator' => 'Sylius\LoyaltyPlugin\Infrastructure\Validator\RegisteredRuleActionTypeValidator',
        'Sylius\Plus\Loyalty\Infrastructure\Validator\SufficientPointsForPurchase' => 'Sylius\LoyaltyPlugin\Infrastructure\Validator\SufficientPointsForPurchase',
        'Sylius\Plus\Loyalty\Infrastructure\Validator\PurchaseEnabledInChannel' => 'Sylius\LoyaltyPlugin\Infrastructure\Validator\PurchaseEnabledInChannel',
        'Sylius\Plus\Loyalty\Infrastructure\Validator\PromotionEligibility' => 'Sylius\LoyaltyPlugin\Infrastructure\Validator\PromotionEligibility',
        'Sylius\Plus\Loyalty\Infrastructure\Validator\PurchaseEnabledInChannelValidator' => 'Sylius\LoyaltyPlugin\Infrastructure\Validator\PurchaseEnabledInChannelValidator',
        'Sylius\Plus\Loyalty\Infrastructure\Validator\PointsPerProductRatioConfigurationEligibilityValidator' => 'Sylius\LoyaltyPlugin\Infrastructure\Validator\PointsPerProductRatioConfigurationEligibilityValidator',
        'Sylius\Plus\Loyalty\Infrastructure\Fixture\LoyaltyRuleFixture' => 'Sylius\LoyaltyPlugin\Infrastructure\Fixture\LoyaltyRuleFixture',
        'Sylius\Plus\Loyalty\Infrastructure\Fixture\Factory\LoyaltyRuleActionExampleFactory' => 'Sylius\LoyaltyPlugin\Infrastructure\Fixture\Factory\LoyaltyRuleActionExampleFactory',
        'Sylius\Plus\Loyalty\Infrastructure\Fixture\Factory\LoyaltyPurchaseExampleFactory' => 'Sylius\LoyaltyPlugin\Infrastructure\Fixture\Factory\LoyaltyPurchaseExampleFactory',
        'Sylius\Plus\Loyalty\Infrastructure\Fixture\Factory\LoyaltyRuleExampleFactory' => 'Sylius\LoyaltyPlugin\Infrastructure\Fixture\Factory\LoyaltyRuleExampleFactory',
        'Sylius\Plus\Loyalty\Infrastructure\Fixture\LoyaltyPurchaseFixture' => 'Sylius\LoyaltyPlugin\Infrastructure\Fixture\LoyaltyPurchaseFixture',
        'Sylius\Plus\Loyalty\Infrastructure\DataTransformer\LoyaltyRuleActionDataTransformerInterface' => 'Sylius\LoyaltyPlugin\Infrastructure\DataTransformer\LoyaltyRuleActionDataTransformerInterface',
        'Sylius\Plus\Loyalty\Infrastructure\DataTransformer\ItemsTotalToPointsRatioConfigurationDataTransformer' => 'Sylius\LoyaltyPlugin\Infrastructure\DataTransformer\ItemsTotalToPointsRatioConfigurationDataTransformer',
        'Sylius\Plus\Loyalty\Infrastructure\DataTransformer\LoyaltyRuleActionInputDataTransformer' => 'Sylius\LoyaltyPlugin\Infrastructure\DataTransformer\LoyaltyRuleActionInputDataTransformer',
        'Sylius\Plus\Loyalty\Infrastructure\DataTransformer\PointsPerProductRatioDataTransformer' => 'Sylius\LoyaltyPlugin\Infrastructure\DataTransformer\PointsPerProductRatioDataTransformer',
        'Sylius\Plus\Loyalty\Infrastructure\DataTransformer\CustomerEmailAwareCommandDataTransformer' => 'Sylius\LoyaltyPlugin\Infrastructure\DataTransformer\CustomerEmailAwareCommandDataTransformer',
        'Sylius\Plus\Loyalty\Infrastructure\Doctrine\QueryCollectionExtension\EnabledLoyaltyPurchasesByChannelExtension' => 'Sylius\LoyaltyPlugin\Infrastructure\Doctrine\QueryCollectionExtension\EnabledLoyaltyPurchasesByChannelExtension',
        'Sylius\Plus\Loyalty\Infrastructure\Doctrine\ORM\ChannelRestrictingEnabledLoyaltyPurchaseListQueryBuilderInterface' => 'Sylius\LoyaltyPlugin\Infrastructure\Doctrine\ORM\ChannelRestrictingEnabledLoyaltyPurchaseListQueryBuilderInterface',
        'Sylius\Plus\Loyalty\Infrastructure\Doctrine\ORM\ChannelRestrictingEnabledLoyaltyPurchaseListQueryBuilder' => 'Sylius\LoyaltyPlugin\Infrastructure\Doctrine\ORM\ChannelRestrictingEnabledLoyaltyPurchaseListQueryBuilder',
        'Sylius\Plus\Loyalty\Infrastructure\Doctrine\ORM\LoyaltyRuleQueryInterface' => 'Sylius\LoyaltyPlugin\Infrastructure\Doctrine\ORM\LoyaltyRuleQueryInterface',
        'Sylius\Plus\Loyalty\Infrastructure\Doctrine\ORM\LoyaltyRuleQuery' => 'Sylius\LoyaltyPlugin\Infrastructure\Doctrine\ORM\LoyaltyRuleQuery',
        'Sylius\Plus\Loyalty\Infrastructure\Menu\ShopAccountMenuListener' => 'Sylius\LoyaltyPlugin\Infrastructure\Menu\ShopAccountMenuListener',
        'Sylius\Plus\Loyalty\Infrastructure\Menu\LoyaltyAdminMenuListener' => 'Sylius\LoyaltyPlugin\Infrastructure\Menu\LoyaltyAdminMenuListener',
        'Sylius\Plus\Loyalty\Infrastructure\Twig\LoyaltyExtension' => 'Sylius\LoyaltyPlugin\Infrastructure\Twig\LoyaltyExtension',
        'Sylius\Plus\Loyalty\Domain\Model\LoyaltyPointsTransactionTypes' => 'Sylius\LoyaltyPlugin\Domain\Model\LoyaltyPointsTransactionTypes',
        'Sylius\Plus\Loyalty\Domain\Model\LoyaltyAwareTrait' => 'Sylius\LoyaltyPlugin\Domain\Model\LoyaltyAwareTrait',
        'Sylius\Plus\Loyalty\Domain\Model\LoyaltyPointsAccountInterface' => 'Sylius\LoyaltyPlugin\Domain\Model\LoyaltyPointsAccountInterface',
        'Sylius\Plus\Loyalty\Domain\Model\LoyaltyAwareInterface' => 'Sylius\LoyaltyPlugin\Domain\Model\LoyaltyAwareInterface',
        'Sylius\Plus\Loyalty\Domain\Model\LoyaltyRuleActionInterface' => 'Sylius\LoyaltyPlugin\Domain\Model\LoyaltyRuleActionInterface',
        'Sylius\Plus\Loyalty\Domain\Model\AdjustmentType' => 'Sylius\LoyaltyPlugin\Domain\Model\AdjustmentType',
        'Sylius\Plus\Loyalty\Domain\Model\LoyaltyPurchase' => 'Sylius\LoyaltyPlugin\Domain\Model\LoyaltyPurchase',
        'Sylius\Plus\Loyalty\Domain\Model\LoyaltyRuleAction' => 'Sylius\LoyaltyPlugin\Domain\Model\LoyaltyRuleAction',
        'Sylius\Plus\Loyalty\Domain\Model\CustomerInterface' => 'Sylius\LoyaltyPlugin\Domain\Model\CustomerInterface',
        'Sylius\Plus\Loyalty\Domain\Model\LoyaltyRuleInterface' => 'Sylius\LoyaltyPlugin\Domain\Model\LoyaltyRuleInterface',
        'Sylius\Plus\Loyalty\Domain\Model\LoyaltyPointsTransactionInterface' => 'Sylius\LoyaltyPlugin\Domain\Model\LoyaltyPointsTransactionInterface',
        'Sylius\Plus\Loyalty\Domain\Model\LoyaltyPointsAccount' => 'Sylius\LoyaltyPlugin\Domain\Model\LoyaltyPointsAccount',
        'Sylius\Plus\Loyalty\Domain\Model\LoyaltyPointsTransaction' => 'Sylius\LoyaltyPlugin\Domain\Model\LoyaltyPointsTransaction',
        'Sylius\Plus\Loyalty\Domain\Model\LoyaltyPurchaseInterface' => 'Sylius\LoyaltyPlugin\Domain\Model\LoyaltyPurchaseInterface',
        'Sylius\Plus\Loyalty\Domain\Model\LoyaltyRuleConfiguration\LoyaltyRuleConfigurationInterface' => 'Sylius\LoyaltyPlugin\Domain\Model\LoyaltyRuleConfiguration\LoyaltyRuleConfigurationInterface',
        'Sylius\Plus\Loyalty\Domain\Model\LoyaltyRuleConfiguration\ChannelsBasedPointsPerProductRatioConfiguration' => 'Sylius\LoyaltyPlugin\Domain\Model\LoyaltyRuleConfiguration\ChannelsBasedPointsPerProductRatioConfiguration',
        'Sylius\Plus\Loyalty\Domain\Model\LoyaltyRuleConfiguration\ItemsTotalToPointsRatioConfiguration' => 'Sylius\LoyaltyPlugin\Domain\Model\LoyaltyRuleConfiguration\ItemsTotalToPointsRatioConfiguration',
        'Sylius\Plus\Loyalty\Domain\Model\LoyaltyRuleConfiguration\PointsPerProductRatioConfiguration' => 'Sylius\LoyaltyPlugin\Domain\Model\LoyaltyRuleConfiguration\PointsPerProductRatioConfiguration',
        'Sylius\Plus\Loyalty\Domain\Model\LoyaltyRuleConfiguration\ChannelsBasedItemsTotalToPointsRatioConfiguration' => 'Sylius\LoyaltyPlugin\Domain\Model\LoyaltyRuleConfiguration\ChannelsBasedItemsTotalToPointsRatioConfiguration',
        'Sylius\Plus\Loyalty\Domain\Model\LoyaltyRuleConfiguration\ChannelBasedLoyaltyRuleConfigurationInterface' => 'Sylius\LoyaltyPlugin\Domain\Model\LoyaltyRuleConfiguration\ChannelBasedLoyaltyRuleConfigurationInterface',
        'Sylius\Plus\Loyalty\Domain\Model\LoyaltyRule' => 'Sylius\LoyaltyPlugin\Domain\Model\LoyaltyRule',
        'Sylius\Plus\Loyalty\DependencyInjection\Compiler\LoyaltyRuleActionsPass' => 'Sylius\LoyaltyPlugin\DependencyInjection\Compiler\LoyaltyRuleActionsPass',
        'Sylius\Plus\PartialShipping\Application\Creator\PartialShipmentCreator' => 'Sylius\CustomerServicePlugin\PartialShipment\Application\Creator\PartialShipmentCreator',
        'Sylius\Plus\PartialShipping\Application\Creator\SplitAndSendShipmentCommandCreator' => 'Sylius\CustomerServicePlugin\PartialShipment\Application\Creator\SplitAndSendShipmentCommandCreator',
        'Sylius\Plus\PartialShipping\Application\Creator\SplitAndSendShipmentCommandCreatorInterface' => 'Sylius\CustomerServicePlugin\PartialShipment\Application\Creator\SplitAndSendShipmentCommandCreatorInterface',
        'Sylius\Plus\PartialShipping\Application\Creator\PartialShipmentCreatorInterface' => 'Sylius\CustomerServicePlugin\PartialShipment\Application\Creator\PartialShipmentCreatorInterface',
        'Sylius\Plus\PartialShipping\Application\CommandHandler\SplitAndSendShipmentHandler' => 'Sylius\CustomerServicePlugin\PartialShipment\Application\CommandHandler\SplitAndSendShipmentHandler',
        'Sylius\Plus\PartialShipping\Application\Purifier\OrderShipmentPurifierInterface' => 'Sylius\CustomerServicePlugin\PartialShipment\Application\Purifier\OrderShipmentPurifierInterface',
        'Sylius\Plus\PartialShipping\Application\Purifier\OrderShipmentPurifier' => 'Sylius\CustomerServicePlugin\PartialShipment\Application\Purifier\OrderShipmentPurifier',
        'Sylius\Plus\PartialShipping\Application\Command\SplitAndSendShipment' => 'Sylius\CustomerServicePlugin\PartialShipment\Application\Command\SplitAndSendShipment',
        'Sylius\Plus\PartialShipping\Application\ShipmentTransitions' => 'Sylius\CustomerServicePlugin\PartialShipment\Application\ShipmentTransitions',
        'Sylius\Plus\PartialShipping\Application\Factory\ShipmentFactory' => 'Sylius\CustomerServicePlugin\PartialShipment\Application\Factory\ShipmentFactory',
        'Sylius\Plus\PartialShipping\Application\Factory\ShipmentFactoryInterface' => 'Sylius\CustomerServicePlugin\PartialShipment\Application\Factory\ShipmentFactoryInterface',
        'Sylius\Plus\PartialShipping\Application\Duplicator\AdjustmentDuplicator' => 'Sylius\CustomerServicePlugin\PartialShipment\Application\Duplicator\AdjustmentDuplicator',
        'Sylius\Plus\PartialShipping\Application\Duplicator\AdjustmentDuplicatorInterface' => 'Sylius\CustomerServicePlugin\PartialShipment\Application\Duplicator\AdjustmentDuplicatorInterface',
        'Sylius\Plus\PartialShipping\Infrastructure\Form\DataTransformer\OrderItemUnitsArrayToOrderItemUnitIdsCollectionTransformer' => 'Sylius\CustomerServicePlugin\PartialShipment\Infrastructure\Form\DataTransformer\OrderItemUnitsArrayToOrderItemUnitIdsCollectionTransformer',
        'Sylius\Plus\PartialShipping\Infrastructure\Form\Type\ShippingUnitsChoiceType' => 'Sylius\CustomerServicePlugin\PartialShipment\Infrastructure\Form\Type\ShippingUnitsChoiceType',
        'Sylius\Plus\PartialShipping\Infrastructure\Form\Type\PartialShipType' => 'Sylius\CustomerServicePlugin\PartialShipment\Infrastructure\Form\Type\PartialShipType',
        'Sylius\Plus\PartialShipping\Infrastructure\Validator\SplitShipmentUnitsEligibility' => 'Sylius\CustomerServicePlugin\PartialShipment\Infrastructure\Validator\SplitShipmentUnitsEligibility',
        'Sylius\Plus\PartialShipping\Infrastructure\Validator\SplitShipmentUnitsEligibilityValidator' => 'Sylius\CustomerServicePlugin\PartialShipment\Infrastructure\Validator\SplitShipmentUnitsEligibilityValidator',
        'Sylius\Plus\PartialShipping\Infrastructure\Modifier\ShipmentUnitModifier' => 'Sylius\CustomerServicePlugin\PartialShipment\Infrastructure\Modifier\ShipmentUnitModifier',
        'Sylius\Plus\PartialShipping\Infrastructure\Modifier\ShipmentUnitModifierInterface' => 'Sylius\CustomerServicePlugin\PartialShipment\Infrastructure\Modifier\ShipmentUnitModifierInterface',
        'Sylius\Plus\PartialShipping\Infrastructure\Splitter\ShipmentSplitterInterface' => 'Sylius\CustomerServicePlugin\PartialShipment\Infrastructure\Splitter\ShipmentSplitterInterface',
        'Sylius\Plus\PartialShipping\Infrastructure\Splitter\InventorySourceShipmentSplitter' => 'Sylius\CustomerServicePlugin\PartialShipment\Infrastructure\Splitter\InventorySourceShipmentSplitter',
        'Sylius\Plus\PartialShipping\Infrastructure\Splitter\ShipmentUnitsSplitter' => 'Sylius\CustomerServicePlugin\PartialShipment\Infrastructure\Splitter\ShipmentUnitsSplitter',
        'Sylius\Plus\PartialShipping\Infrastructure\Splitter\ShipmentUnitsSplitterInterface' => 'Sylius\CustomerServicePlugin\PartialShipment\Infrastructure\Splitter\ShipmentUnitsSplitterInterface',
        'Sylius\Plus\PartialShipping\Infrastructure\Splitter\InventorySourceShipmentSplitterInterface' => 'Sylius\CustomerServicePlugin\PartialShipment\Infrastructure\Splitter\InventorySourceShipmentSplitterInterface',
        'Sylius\Plus\PartialShipping\Infrastructure\Splitter\ShipmentSplitter' => 'Sylius\CustomerServicePlugin\PartialShipment\Infrastructure\Splitter\ShipmentSplitter',
        'Sylius\Plus\Inventory\Tests\Unit\Application\Updater\InventorySourceStockUpdaterTest' => 'Sylius\MultiSourceInventoryPlugin\Tests\Unit\Application\Updater\InventorySourceStockUpdaterTest',
        'Sylius\Plus\Inventory\Tests\Unit\Infrastructure\Fixture\InventorySourceTest' => 'Sylius\MultiSourceInventoryPlugin\Tests\Unit\Infrastructure\Fixture\InventorySourceTest',
        'Sylius\Plus\Inventory\Tests\Unit\Domain\Model\InventorySourceAwareTraitTest' => 'Sylius\MultiSourceInventoryPlugin\Tests\Unit\Domain\Model\InventorySourceAwareTraitTest',
        'Sylius\Plus\Inventory\Tests\Unit\Domain\Model\InventorySourceStocksAwareTraitTest' => 'Sylius\MultiSourceInventoryPlugin\Tests\Unit\Domain\Model\InventorySourceStocksAwareTraitTest',
        'Sylius\Plus\Inventory\Application\CommandHandler\ModifyInventorySourceStockHandler' => 'Sylius\MultiSourceInventoryPlugin\Application\CommandHandler\ModifyInventorySourceStockHandler',
        'Sylius\Plus\Inventory\Application\Checker\AvailabilityChecker' => 'Sylius\MultiSourceInventoryPlugin\Application\Checker\AvailabilityChecker',
        'Sylius\Plus\Inventory\Application\Checker\VariantQuantityMapAvailabilityChecker' => 'Sylius\MultiSourceInventoryPlugin\Application\Checker\VariantQuantityMapAvailabilityChecker',
        'Sylius\Plus\Inventory\Application\Checker\IsStockSufficientCheckerInterface' => 'Sylius\MultiSourceInventoryPlugin\Application\Checker\IsStockSufficientCheckerInterface',
        'Sylius\Plus\Inventory\Application\Checker\VariantAvailabilityChecker' => 'Sylius\MultiSourceInventoryPlugin\Application\Checker\VariantAvailabilityChecker',
        'Sylius\Plus\Inventory\Application\Checker\IsStockSufficientChecker' => 'Sylius\MultiSourceInventoryPlugin\Application\Checker\IsStockSufficientChecker',
        'Sylius\Plus\Inventory\Application\Checker\AvailabilityCheckerInterface' => 'Sylius\MultiSourceInventoryPlugin\Application\Checker\AvailabilityCheckerInterface',
        'Sylius\Plus\Inventory\Application\Checker\VariantQuantityMapAvailabilityCheckerInterface' => 'Sylius\MultiSourceInventoryPlugin\Application\Checker\VariantQuantityMapAvailabilityCheckerInterface',
        'Sylius\Plus\Inventory\Application\Checker\VariantAvailabilityCheckerInterface' => 'Sylius\MultiSourceInventoryPlugin\Application\Checker\VariantAvailabilityCheckerInterface',
        'Sylius\Plus\Inventory\Application\Provider\InsufficientItemFromOrderItemsProvider' => 'Sylius\MultiSourceInventoryPlugin\Application\Provider\InsufficientItemFromOrderItemsProvider',
        'Sylius\Plus\Inventory\Application\Provider\AvailableInventorySourcesProvider' => 'Sylius\MultiSourceInventoryPlugin\Application\Provider\AvailableInventorySourcesProvider',
        'Sylius\Plus\Inventory\Application\Provider\InsufficientItemFromOrderItemsProviderInterface' => 'Sylius\MultiSourceInventoryPlugin\Application\Provider\InsufficientItemFromOrderItemsProviderInterface',
        'Sylius\Plus\Inventory\Application\Provider\AvailableInventorySourcesProviderInterface' => 'Sylius\MultiSourceInventoryPlugin\Application\Provider\AvailableInventorySourcesProviderInterface',
        'Sylius\Plus\Inventory\Application\Updater\InventorySourceStockUpdaterInterface' => 'Sylius\MultiSourceInventoryPlugin\Application\Updater\InventorySourceStockUpdaterInterface',
        'Sylius\Plus\Inventory\Application\Updater\InventorySourceStockUpdater' => 'Sylius\MultiSourceInventoryPlugin\Application\Updater\InventorySourceStockUpdater',
        'Sylius\Plus\Inventory\Application\Controller\OrderItemController' => 'Sylius\MultiSourceInventoryPlugin\Application\Controller\OrderItemController',
        'Sylius\Plus\Inventory\Application\DataPersister\InventorySourceStockDataPersister' => 'Sylius\MultiSourceInventoryPlugin\Application\DataPersister\InventorySourceStockDataPersister',
        'Sylius\Plus\Inventory\Application\DataPersister\ProductVariantDataPersister' => 'Sylius\MultiSourceInventoryPlugin\Application\DataPersister\ProductVariantDataPersister',
        'Sylius\Plus\Inventory\Application\DataPersister\InventorySourceDataPersister' => 'Sylius\MultiSourceInventoryPlugin\Application\DataPersister\InventorySourceDataPersister',
        'Sylius\Plus\Inventory\Application\Command\ModifyInventorySourceStock' => 'Sylius\MultiSourceInventoryPlugin\Application\Command\ModifyInventorySourceStock',
        'Sylius\Plus\Inventory\Application\Filter\PriorityInventorySourcesFilter' => 'Sylius\MultiSourceInventoryPlugin\Application\Filter\PriorityInventorySourcesFilter',
        'Sylius\Plus\Inventory\Application\Filter\SufficientInventorySourcesFilter' => 'Sylius\MultiSourceInventoryPlugin\Application\Filter\SufficientInventorySourcesFilter',
        'Sylius\Plus\Inventory\Application\Filter\InventorySourcesFilterInterface' => 'Sylius\MultiSourceInventoryPlugin\Application\Filter\InventorySourcesFilterInterface',
        'Sylius\Plus\Inventory\Application\Filter\EnabledChannelInventorySourcesFilter' => 'Sylius\MultiSourceInventoryPlugin\Application\Filter\EnabledChannelInventorySourcesFilter',
        'Sylius\Plus\Inventory\Application\Assigner\ShipmentInventorySourceAssigner' => 'Sylius\MultiSourceInventoryPlugin\Application\Assigner\ShipmentInventorySourceAssigner',
        'Sylius\Plus\Inventory\Application\Assigner\ShipmentInventorySourceAssignerInterface' => 'Sylius\MultiSourceInventoryPlugin\Application\Assigner\ShipmentInventorySourceAssignerInterface',
        'Sylius\Plus\Inventory\Application\Factory\InventorySourceFactoryInterface' => 'Sylius\MultiSourceInventoryPlugin\Application\Factory\InventorySourceFactoryInterface',
        'Sylius\Plus\Inventory\Application\Factory\InventorySourceFactory' => 'Sylius\MultiSourceInventoryPlugin\Application\Factory\InventorySourceFactory',
        'Sylius\Plus\Inventory\Application\Operator\HoldOrderInventoryOperatorInterface' => 'Sylius\MultiSourceInventoryPlugin\Application\Operator\HoldOrderInventoryOperatorInterface',
        'Sylius\Plus\Inventory\Application\Operator\HoldOrderInventoryOperator' => 'Sylius\MultiSourceInventoryPlugin\Application\Operator\HoldOrderInventoryOperator',
        'Sylius\Plus\Inventory\Application\Operator\InventoryOperatorInterface' => 'Sylius\MultiSourceInventoryPlugin\Application\Operator\InventoryOperatorInterface',
        'Sylius\Plus\Inventory\Application\Operator\CancelOrderInventoryOperatorInterface' => 'Sylius\MultiSourceInventoryPlugin\Application\Operator\CancelOrderInventoryOperatorInterface',
        'Sylius\Plus\Inventory\Application\Operator\ShipmentInventoryOperator' => 'Sylius\MultiSourceInventoryPlugin\Application\Operator\ShipmentInventoryOperator',
        'Sylius\Plus\Inventory\Application\Operator\ChangeInventorySourceOperator' => 'Sylius\MultiSourceInventoryPlugin\Application\Operator\ChangeInventorySourceOperator',
        'Sylius\Plus\Inventory\Application\Operator\CancelOrderInventoryOperator' => 'Sylius\MultiSourceInventoryPlugin\Application\Operator\CancelOrderInventoryOperator',
        'Sylius\Plus\Inventory\Application\Operator\ShipShipmentInventoryOperatorInterface' => 'Sylius\MultiSourceInventoryPlugin\Application\Operator\ShipShipmentInventoryOperatorInterface',
        'Sylius\Plus\Inventory\Application\Operator\ShipShipmentInventoryOperator' => 'Sylius\MultiSourceInventoryPlugin\Application\Operator\ShipShipmentInventoryOperator',
        'Sylius\Plus\Inventory\Application\Operator\InventoryOperator' => 'Sylius\MultiSourceInventoryPlugin\Application\Operator\InventoryOperator',
        'Sylius\Plus\Inventory\Application\Operator\ChangeInventorySourceOperatorInterface' => 'Sylius\MultiSourceInventoryPlugin\Application\Operator\ChangeInventorySourceOperatorInterface',
        'Sylius\Plus\Inventory\Application\Operator\ShipmentInventoryOperatorInterface' => 'Sylius\MultiSourceInventoryPlugin\Application\Operator\ShipmentInventoryOperatorInterface',
        'Sylius\Plus\Inventory\Application\Resolver\InventorySourceResolver' => 'Sylius\MultiSourceInventoryPlugin\Application\Resolver\InventorySourceResolver',
        'Sylius\Plus\Inventory\Application\Resolver\InventorySourceResolverInterface' => 'Sylius\MultiSourceInventoryPlugin\Application\Resolver\InventorySourceResolverInterface',
        'Sylius\Plus\Inventory\Application\EventListener\InventorySourceDeletionListener' => 'Sylius\MultiSourceInventoryPlugin\Application\EventListener\InventorySourceDeletionListener',
        'Sylius\Plus\Inventory\Application\EventListener\ChannelCreateListener' => 'Sylius\MultiSourceInventoryPlugin\Application\EventListener\ChannelCreateListener',
        'Sylius\Plus\Inventory\Infrastructure\Ui\ChangeInventorySourceStockOnHandAction' => 'Sylius\MultiSourceInventoryPlugin\Infrastructure\Ui\ChangeInventorySourceStockOnHandAction',
        'Sylius\Plus\Inventory\Infrastructure\Form\Extension\ProductVariantTypeExtension' => 'Sylius\MultiSourceInventoryPlugin\Infrastructure\Form\Extension\ProductVariantTypeExtension',
        'Sylius\Plus\Inventory\Infrastructure\Form\Type\InventorySourceStockType' => 'Sylius\MultiSourceInventoryPlugin\Infrastructure\Form\Type\InventorySourceStockType',
        'Sylius\Plus\Inventory\Infrastructure\Form\Type\InventorySourceStockOnHandType' => 'Sylius\MultiSourceInventoryPlugin\Infrastructure\Form\Type\InventorySourceStockOnHandType',
        'Sylius\Plus\Inventory\Infrastructure\Form\Type\InventorySourceType' => 'Sylius\MultiSourceInventoryPlugin\Infrastructure\Form\Type\InventorySourceType',
        'Sylius\Plus\Inventory\Infrastructure\Form\Type\InventorySourceChoiceType' => 'Sylius\MultiSourceInventoryPlugin\Infrastructure\Form\Type\InventorySourceChoiceType',
        'Sylius\Plus\Inventory\Infrastructure\Form\Type\InventorySourceAddressType' => 'Sylius\MultiSourceInventoryPlugin\Infrastructure\Form\Type\InventorySourceAddressType',
        'Sylius\Plus\Inventory\Infrastructure\Form\Type\InventorySourceCollectionType' => 'Sylius\MultiSourceInventoryPlugin\Infrastructure\Form\Type\InventorySourceCollectionType',
        'Sylius\Plus\Inventory\Infrastructure\Validator\CartItemAvailability' => 'Sylius\MultiSourceInventoryPlugin\Infrastructure\Validator\CartItemAvailability',
        'Sylius\Plus\Inventory\Infrastructure\Validator\StockOnHandCannotBeLowerThanOnHold' => 'Sylius\MultiSourceInventoryPlugin\Infrastructure\Validator\StockOnHandCannotBeLowerThanOnHold',
        'Sylius\Plus\Inventory\Infrastructure\Validator\NoInventorySourceForTrackedItemUnits' => 'Sylius\MultiSourceInventoryPlugin\Infrastructure\Validator\NoInventorySourceForTrackedItemUnits',
        'Sylius\Plus\Inventory\Infrastructure\Validator\OrderInStockValidator' => 'Sylius\MultiSourceInventoryPlugin\Infrastructure\Validator\OrderInStockValidator',
        'Sylius\Plus\Inventory\Infrastructure\Validator\OrderInStock' => 'Sylius\MultiSourceInventoryPlugin\Infrastructure\Validator\OrderInStock',
        'Sylius\Plus\Inventory\Infrastructure\Validator\NoInventorySourceForTrackedItemUnitsValidator' => 'Sylius\MultiSourceInventoryPlugin\Infrastructure\Validator\NoInventorySourceForTrackedItemUnitsValidator',
        'Sylius\Plus\Inventory\Infrastructure\Validator\StockOnHandCannotBeLowerThanOnHoldValidator' => 'Sylius\MultiSourceInventoryPlugin\Infrastructure\Validator\StockOnHandCannotBeLowerThanOnHoldValidator',
        'Sylius\Plus\Inventory\Infrastructure\Validator\CartItemAvailabilityValidator' => 'Sylius\MultiSourceInventoryPlugin\Infrastructure\Validator\CartItemAvailabilityValidator',
        'Sylius\Plus\Inventory\Infrastructure\Validator\OrderItemClassMetadataLoader' => 'Sylius\MultiSourceInventoryPlugin\Infrastructure\Validator\OrderItemClassMetadataLoader',
        'Sylius\Plus\Inventory\Infrastructure\Fixture\InventorySourceStockFixture' => 'Sylius\MultiSourceInventoryPlugin\Infrastructure\Fixture\InventorySourceStockFixture',
        'Sylius\Plus\Inventory\Infrastructure\Fixture\InventorySourceFixture' => 'Sylius\MultiSourceInventoryPlugin\Infrastructure\Fixture\InventorySourceFixture',
        'Sylius\Plus\Inventory\Infrastructure\Fixture\Factory\InventorySourceExampleFactory' => 'Sylius\MultiSourceInventoryPlugin\Infrastructure\Fixture\Factory\InventorySourceExampleFactory',
        'Sylius\Plus\Inventory\Infrastructure\Doctrine\ORM\FindAllDescendantProductsByTaxonQueryInterface' => 'Sylius\MultiSourceInventoryPlugin\Infrastructure\Doctrine\ORM\FindAllDescendantProductsByTaxonQueryInterface',
        'Sylius\Plus\Inventory\Infrastructure\Doctrine\ORM\InventorySourceStockRepositoryInterface' => 'Sylius\MultiSourceInventoryPlugin\Infrastructure\Doctrine\ORM\InventorySourceStockRepositoryInterface',
        'Sylius\Plus\Inventory\Infrastructure\Doctrine\ORM\InventorySourceStockRepository' => 'Sylius\MultiSourceInventoryPlugin\Infrastructure\Doctrine\ORM\InventorySourceStockRepository',
        'Sylius\Plus\Inventory\Infrastructure\Doctrine\ORM\FindAllDescendantProductsByTaxonQuery' => 'Sylius\MultiSourceInventoryPlugin\Infrastructure\Doctrine\ORM\FindAllDescendantProductsByTaxonQuery',
        'Sylius\Plus\Inventory\Infrastructure\Menu\AdminMenuListener' => 'Sylius\MultiSourceInventoryPlugin\Infrastructure\Menu\AdminMenuListener',
        'Sylius\Plus\Inventory\Infrastructure\Twig\InventoryExtension' => 'Sylius\MultiSourceInventoryPlugin\Infrastructure\Twig\InventoryExtension',
        'Sylius\Plus\Inventory\Domain\Model\InventorySourceAwareInterface' => 'Sylius\MultiSourceInventoryPlugin\Domain\Model\InventorySourceAwareInterface',
        'Sylius\Plus\Inventory\Domain\Model\InventorySourceAddressInterface' => 'Sylius\MultiSourceInventoryPlugin\Domain\Model\InventorySourceAddressInterface',
        'Sylius\Plus\Inventory\Domain\Model\InventorySourceStocksAwareTrait' => 'Sylius\MultiSourceInventoryPlugin\Domain\Model\InventorySourceStocksAwareTrait',
        'Sylius\Plus\Inventory\Domain\Model\InventoryAwareInterface' => 'Sylius\MultiSourceInventoryPlugin\Domain\Model\InventoryAwareInterface',
        'Sylius\Plus\Inventory\Domain\Model\InventorySourceStocksAwareInterface' => 'Sylius\MultiSourceInventoryPlugin\Domain\Model\InventorySourceStocksAwareInterface',
        'Sylius\Plus\Inventory\Domain\Model\VariantsQuantityMap' => 'Sylius\MultiSourceInventoryPlugin\Domain\Model\VariantsQuantityMap',
        'Sylius\Plus\Inventory\Domain\Model\ShipmentInterface' => 'Sylius\MultiSourceInventoryPlugin\Domain\Model\ShipmentInterface',
        'Sylius\Plus\Inventory\Domain\Model\VariantsQuantityMapInterface' => 'Sylius\MultiSourceInventoryPlugin\Domain\Model\VariantsQuantityMapInterface',
        'Sylius\Plus\Inventory\Domain\Model\InventorySourceStockInterface' => 'Sylius\MultiSourceInventoryPlugin\Domain\Model\InventorySourceStockInterface',
        'Sylius\Plus\Inventory\Domain\Model\InventorySourceStock' => 'Sylius\MultiSourceInventoryPlugin\Domain\Model\InventorySourceStock',
        'Sylius\Plus\Inventory\Domain\Model\InventorySourceAddress' => 'Sylius\MultiSourceInventoryPlugin\Domain\Model\InventorySourceAddress',
        'Sylius\Plus\Inventory\Domain\Model\InventorySourceInterface' => 'Sylius\MultiSourceInventoryPlugin\Domain\Model\InventorySourceInterface',
        'Sylius\Plus\Inventory\Domain\Model\InventorySourceAwareTrait' => 'Sylius\MultiSourceInventoryPlugin\Domain\Model\InventorySourceAwareTrait',
        'Sylius\Plus\Inventory\Domain\Model\InventorySource' => 'Sylius\MultiSourceInventoryPlugin\Domain\Model\InventorySource',
        'Sylius\Plus\Inventory\Domain\Model\ProductVariantInterface' => 'Sylius\MultiSourceInventoryPlugin\Domain\Model\ProductVariantInterface',
        'Sylius\Plus\Inventory\Domain\Exception\VariantQuantityNotSpecified' => 'Sylius\MultiSourceInventoryPlugin\Domain\Exception\VariantQuantityNotSpecified',
        'Sylius\Plus\Inventory\Domain\Exception\InventorySourceStockInUseException' => 'Sylius\MultiSourceInventoryPlugin\Domain\Exception\InventorySourceStockInUseException',
        'Sylius\Plus\Inventory\Domain\Exception\InventorySourceStockNotFoundException' => 'Sylius\MultiSourceInventoryPlugin\Domain\Exception\InventorySourceStockNotFoundException',
        'Sylius\Plus\Inventory\Domain\Exception\VariantQuantityAlreadySpecified' => 'Sylius\MultiSourceInventoryPlugin\Domain\Exception\VariantQuantityAlreadySpecified',
        'Sylius\Plus\Inventory\Domain\Exception\UnresolvedInventorySource' => 'Sylius\MultiSourceInventoryPlugin\Domain\Exception\UnresolvedInventorySource',
        'Sylius\Plus\Inventory\DependencyInjection\Compiler\InventoryPass' => 'Sylius\MultiSourceInventoryPlugin\DependencyInjection\Compiler\InventoryPass',
        'Sylius\Plus\Returns\Tests\Unit\Infrastructure\Ui\Admin\MarkReturnRequestAsRepairedItemsSentActionTest' => 'Sylius\ReturnPlugin\Tests\Unit\Infrastructure\Ui\Admin\MarkReturnRequestAsRepairedItemsSentActionTest',
        'Sylius\Plus\Returns\Tests\Unit\Infrastructure\Ui\Admin\MarkReturnRequestUnitsAsReceivedActionTest' => 'Sylius\ReturnPlugin\Tests\Unit\Infrastructure\Ui\Admin\MarkReturnRequestUnitsAsReceivedActionTest',
        'Sylius\Plus\Returns\Tests\Unit\Infrastructure\Ui\Admin\RefundUnitsActionTest' => 'Sylius\ReturnPlugin\Tests\Unit\Infrastructure\Ui\Admin\RefundUnitsActionTest',
        'Sylius\Plus\Returns\Tests\Unit\Infrastructure\Ui\Admin\AcceptReturnRequestActionTest' => 'Sylius\ReturnPlugin\Tests\Unit\Infrastructure\Ui\Admin\AcceptReturnRequestActionTest',
        'Sylius\Plus\Returns\Tests\Unit\Infrastructure\Ui\Admin\ResolveReturnRequestActionTest' => 'Sylius\ReturnPlugin\Tests\Unit\Infrastructure\Ui\Admin\ResolveReturnRequestActionTest',
        'Sylius\Plus\Returns\Tests\Unit\Infrastructure\Ui\Admin\RejectReturnRequestActionTest' => 'Sylius\ReturnPlugin\Tests\Unit\Infrastructure\Ui\Admin\RejectReturnRequestActionTest',
        'Sylius\Plus\Returns\Tests\Unit\Infrastucture\Ui\Admin\SessionAwareActionTestCase' => 'Sylius\ReturnPlugin\Tests\Unit\Infrastucture\Ui\Admin\SessionAwareActionTestCase',
        'Sylius\Plus\Returns\Tests\Unit\Domain\Model\ReturnRequestAwareTraitTest' => 'Sylius\ReturnPlugin\Tests\Unit\Domain\Model\ReturnRequestAwareTraitTest',
        'Sylius\Plus\Returns\Tests\Unit\Domain\Model\ReturnRequestsAllowedAwareTraitTest' => 'Sylius\ReturnPlugin\Tests\Unit\Domain\Model\ReturnRequestsAllowedAwareTraitTest',
        'Sylius\Plus\Returns\Application\Creator\ChangeReturnRequestResolutionCommandCreator' => 'Sylius\ReturnPlugin\Application\Creator\ChangeReturnRequestResolutionCommandCreator',
        'Sylius\Plus\Returns\Application\Creator\ReplacementOrderCreatorInterface' => 'Sylius\ReturnPlugin\Application\Creator\ReplacementOrderCreatorInterface',
        'Sylius\Plus\Returns\Application\Creator\ChangeReturnRequestResolutionCommandCreatorInterface' => 'Sylius\ReturnPlugin\Application\Creator\ChangeReturnRequestResolutionCommandCreatorInterface',
        'Sylius\Plus\Returns\Application\Creator\ReplacementOrderCreator' => 'Sylius\ReturnPlugin\Application\Creator\ReplacementOrderCreator',
        'Sylius\Plus\Returns\Application\CommandHandler\MarkReturnRequestAsItemsReturnedToInventoryHandler' => 'Sylius\ReturnPlugin\Application\CommandHandler\MarkReturnRequestAsItemsReturnedToInventoryHandler',
        'Sylius\Plus\Returns\Application\CommandHandler\AcceptReturnRequestHandler' => 'Sylius\ReturnPlugin\Application\CommandHandler\AcceptReturnRequestHandler',
        'Sylius\Plus\Returns\Application\CommandHandler\CreateReplacementOrderHandler' => 'Sylius\ReturnPlugin\Application\CommandHandler\CreateReplacementOrderHandler',
        'Sylius\Plus\Returns\Application\CommandHandler\MarkReturnRequestAsPackageReceivedHandler' => 'Sylius\ReturnPlugin\Application\CommandHandler\MarkReturnRequestAsPackageReceivedHandler',
        'Sylius\Plus\Returns\Application\CommandHandler\ResolveReturnRequestHandler' => 'Sylius\ReturnPlugin\Application\CommandHandler\ResolveReturnRequestHandler',
        'Sylius\Plus\Returns\Application\CommandHandler\RejectReturnRequestHandler' => 'Sylius\ReturnPlugin\Application\CommandHandler\RejectReturnRequestHandler',
        'Sylius\Plus\Returns\Application\CommandHandler\ReturnUnitsToInventoryHandler' => 'Sylius\ReturnPlugin\Application\CommandHandler\ReturnUnitsToInventoryHandler',
        'Sylius\Plus\Returns\Application\CommandHandler\CancelReturnRequestHandler' => 'Sylius\ReturnPlugin\Application\CommandHandler\CancelReturnRequestHandler',
        'Sylius\Plus\Returns\Application\CommandHandler\SplitReturnRequestHandler' => 'Sylius\ReturnPlugin\Application\CommandHandler\SplitReturnRequestHandler',
        'Sylius\Plus\Returns\Application\CommandHandler\RequestReturnHandler' => 'Sylius\ReturnPlugin\Application\CommandHandler\RequestReturnHandler',
        'Sylius\Plus\Returns\Application\CommandHandler\ChangeReturnRequestResolutionHandler' => 'Sylius\ReturnPlugin\Application\CommandHandler\ChangeReturnRequestResolutionHandler',
        'Sylius\Plus\Returns\Application\CommandHandler\MarkReturnRequestAsRepairedItemsSentHandler' => 'Sylius\ReturnPlugin\Application\CommandHandler\MarkReturnRequestAsRepairedItemsSentHandler',
        'Sylius\Plus\Returns\Application\CommandHandler\SendReturnRequestConfirmationHandler' => 'Sylius\ReturnPlugin\Application\CommandHandler\SendReturnRequestConfirmationHandler',
        'Sylius\Plus\Returns\Application\CommandHandler\SendReturnRequestSplitInformationHandler' => 'Sylius\ReturnPlugin\Application\CommandHandler\SendReturnRequestSplitInformationHandler',
        'Sylius\Plus\Returns\Application\CommandHandler\MarkReturnRequestUnitsAsReceivedHandler' => 'Sylius\ReturnPlugin\Application\CommandHandler\MarkReturnRequestUnitsAsReceivedHandler',
        'Sylius\Plus\Returns\Application\Calculator\ShippingCalculator\DelegatingCalculator' => 'Sylius\ReturnPlugin\Application\Calculator\ShippingCalculator\DelegatingCalculator',
        'Sylius\Plus\Returns\Application\Calculator\ReturnRateMetricCalculatorInterface' => 'Sylius\ReturnPlugin\Application\Calculator\ReturnRateMetricCalculatorInterface',
        'Sylius\Plus\Returns\Application\Calculator\ReturnRateMetricCalculator' => 'Sylius\ReturnPlugin\Application\Calculator\ReturnRateMetricCalculator',
        'Sylius\Plus\Returns\Application\Checker\ReturnRequestCustomerRelationCheckerInterface' => 'Sylius\ReturnPlugin\Application\Checker\ReturnRequestCustomerRelationCheckerInterface',
        'Sylius\Plus\Returns\Application\Checker\OrderItemsAvailabilityCheckerInterface' => 'Sylius\ReturnPlugin\Application\Checker\OrderItemsAvailabilityCheckerInterface',
        'Sylius\Plus\Returns\Application\Checker\ReturnRequestAllUnitsReturnedToInventoryChecker' => 'Sylius\ReturnPlugin\Application\Checker\ReturnRequestAllUnitsReturnedToInventoryChecker',
        'Sylius\Plus\Returns\Application\Checker\ReturnRequestAllUnitsReceivedChecker' => 'Sylius\ReturnPlugin\Application\Checker\ReturnRequestAllUnitsReceivedChecker',
        'Sylius\Plus\Returns\Application\Checker\ReturnRequestCustomerRelationChecker' => 'Sylius\ReturnPlugin\Application\Checker\ReturnRequestCustomerRelationChecker',
        'Sylius\Plus\Returns\Application\Checker\ReturnRequestAllUnitsReceivedCheckerInterface' => 'Sylius\ReturnPlugin\Application\Checker\ReturnRequestAllUnitsReceivedCheckerInterface',
        'Sylius\Plus\Returns\Application\Checker\ReturnRequestAllUnitsReturnedToInventoryCheckerInterface' => 'Sylius\ReturnPlugin\Application\Checker\ReturnRequestAllUnitsReturnedToInventoryCheckerInterface',
        'Sylius\Plus\Returns\Application\Checker\OrderItemsAvailabilityChecker' => 'Sylius\ReturnPlugin\Application\Checker\OrderItemsAvailabilityChecker',
        'Sylius\Plus\Returns\Application\Checker\ReturnRequestResourceChannelChecker' => 'Sylius\ReturnPlugin\Application\Checker\ReturnRequestResourceChannelChecker',
        'Sylius\Plus\Returns\Application\Notification\ReturnRequestNotificationEmailSender' => 'Sylius\ReturnPlugin\Application\Notification\ReturnRequestNotificationEmailSender',
        'Sylius\Plus\Returns\Application\Notification\ReturnRequestConfirmationEmailSender' => 'Sylius\ReturnPlugin\Application\Notification\ReturnRequestConfirmationEmailSender',
        'Sylius\Plus\Returns\Application\Processor\OrderReplacementProcessor' => 'Sylius\ReturnPlugin\Application\Processor\OrderReplacementProcessor',
        'Sylius\Plus\Returns\Application\Mapper\ReturnRequestUnitMapper' => 'Sylius\ReturnPlugin\Application\Mapper\ReturnRequestUnitMapper',
        'Sylius\Plus\Returns\Application\Mapper\ReturnRequestUnitMapperInterface' => 'Sylius\ReturnPlugin\Application\Mapper\ReturnRequestUnitMapperInterface',
        'Sylius\Plus\Returns\Application\Provider\NonReturnableOrderItemUnitIdsProviderInterface' => 'Sylius\ReturnPlugin\Application\Provider\NonReturnableOrderItemUnitIdsProviderInterface',
        'Sylius\Plus\Returns\Application\Provider\StringReturnRequestResolutionsProvider' => 'Sylius\ReturnPlugin\Application\Provider\StringReturnRequestResolutionsProvider',
        'Sylius\Plus\Returns\Application\Provider\NonReturnableOrderItemUnitIdsProvider' => 'Sylius\ReturnPlugin\Application\Provider\NonReturnableOrderItemUnitIdsProvider',
        'Sylius\Plus\Returns\Application\Provider\ReturnRequestProviderInterface' => 'Sylius\ReturnPlugin\Application\Provider\ReturnRequestProviderInterface',
        'Sylius\Plus\Returns\Application\Provider\RequestBasedReturnRequestProvider' => 'Sylius\ReturnPlugin\Application\Provider\RequestBasedReturnRequestProvider',
        'Sylius\Plus\Returns\Application\Provider\Calendar' => 'Sylius\ReturnPlugin\Application\Provider\Calendar',
        'Sylius\Plus\Returns\Application\Mailer\Emails' => 'Sylius\ReturnPlugin\Application\Mailer\Emails',
        'Sylius\Plus\Returns\Application\Controller\ReturnableOrderItemUnitsController' => 'Sylius\ReturnPlugin\Application\Controller\ReturnableOrderItemUnitsController',
        'Sylius\Plus\Returns\Application\Controller\AvailableReturnRequestResolutionsController' => 'Sylius\ReturnPlugin\Application\Controller\AvailableReturnRequestResolutionsController',
        'Sylius\Plus\Returns\Application\Generator\ReturnRequestPdfFileGenerator' => 'Sylius\ReturnPlugin\Application\Generator\ReturnRequestPdfFileGenerator',
        'Sylius\Plus\Returns\Application\Generator\ReturnRequestPdfFileGeneratorInterface' => 'Sylius\ReturnPlugin\Application\Generator\ReturnRequestPdfFileGeneratorInterface',
        'Sylius\Plus\Returns\Application\Generator\SequentialReturnRequestNumberGenerator' => 'Sylius\ReturnPlugin\Application\Generator\SequentialReturnRequestNumberGenerator',
        'Sylius\Plus\Returns\Application\Generator\ReturnRequestNumberGenerator' => 'Sylius\ReturnPlugin\Application\Generator\ReturnRequestNumberGenerator',
        'Sylius\Plus\Returns\Application\Command\MarkReturnRequestAsPackageReceived' => 'Sylius\ReturnPlugin\Application\Command\MarkReturnRequestAsPackageReceived',
        'Sylius\Plus\Returns\Application\Command\ChangeReturnRequestResolution' => 'Sylius\ReturnPlugin\Application\Command\ChangeReturnRequestResolution',
        'Sylius\Plus\Returns\Application\Command\MarkReturnRequestUnitsAsReceived' => 'Sylius\ReturnPlugin\Application\Command\MarkReturnRequestUnitsAsReceived',
        'Sylius\Plus\Returns\Application\Command\MarkReturnRequestAsItemsReturnedToInventory' => 'Sylius\ReturnPlugin\Application\Command\MarkReturnRequestAsItemsReturnedToInventory',
        'Sylius\Plus\Returns\Application\Command\ResolveReturnRequest' => 'Sylius\ReturnPlugin\Application\Command\ResolveReturnRequest',
        'Sylius\Plus\Returns\Application\Command\CancelReturnRequest' => 'Sylius\ReturnPlugin\Application\Command\CancelReturnRequest',
        'Sylius\Plus\Returns\Application\Command\MarkReturnRequestAsRepairedItemsSent' => 'Sylius\ReturnPlugin\Application\Command\MarkReturnRequestAsRepairedItemsSent',
        'Sylius\Plus\Returns\Application\Command\AcceptReturnRequest' => 'Sylius\ReturnPlugin\Application\Command\AcceptReturnRequest',
        'Sylius\Plus\Returns\Application\Command\RequestReturn' => 'Sylius\ReturnPlugin\Application\Command\RequestReturn',
        'Sylius\Plus\Returns\Application\Command\SendReturnRequestSplitInformation' => 'Sylius\ReturnPlugin\Application\Command\SendReturnRequestSplitInformation',
        'Sylius\Plus\Returns\Application\Command\ReturnUnitsToInventory' => 'Sylius\ReturnPlugin\Application\Command\ReturnUnitsToInventory',
        'Sylius\Plus\Returns\Application\Command\Model\ReturnRequestUnitReturnToInventoryInterface' => 'Sylius\ReturnPlugin\Application\Command\Model\ReturnRequestUnitReturnToInventoryInterface',
        'Sylius\Plus\Returns\Application\Command\Model\ReturnRequestUnitReturnToInventory' => 'Sylius\ReturnPlugin\Application\Command\Model\ReturnRequestUnitReturnToInventory',
        'Sylius\Plus\Returns\Application\Command\SendReturnRequestConfirmation' => 'Sylius\ReturnPlugin\Application\Command\SendReturnRequestConfirmation',
        'Sylius\Plus\Returns\Application\Command\RejectReturnRequest' => 'Sylius\ReturnPlugin\Application\Command\RejectReturnRequest',
        'Sylius\Plus\Returns\Application\Command\SplitReturnRequest' => 'Sylius\ReturnPlugin\Application\Command\SplitReturnRequest',
        'Sylius\Plus\Returns\Application\Command\CreateReplacementOrder' => 'Sylius\ReturnPlugin\Application\Command\CreateReplacementOrder',
        'Sylius\Plus\Returns\Application\Guard\ReturnRequestGuard' => 'Sylius\ReturnPlugin\Application\Guard\ReturnRequestGuard',
        'Sylius\Plus\Returns\Application\Guard\ReturnRequestGuardInterface' => 'Sylius\ReturnPlugin\Application\Guard\ReturnRequestGuardInterface',
        'Sylius\Plus\Returns\Application\Exception\InsufficientStockWhileCreatingReplacementOrder' => 'Sylius\ReturnPlugin\Application\Exception\InsufficientStockWhileCreatingReplacementOrder',
        'Sylius\Plus\Returns\Application\Exception\ReturnRequestNotAccessible' => 'Sylius\ReturnPlugin\Application\Exception\ReturnRequestNotAccessible',
        'Sylius\Plus\Returns\Application\Factory\ReturnRequestFactoryInterface' => 'Sylius\ReturnPlugin\Application\Factory\ReturnRequestFactoryInterface',
        'Sylius\Plus\Returns\Application\Factory\ReturnRequestFactory' => 'Sylius\ReturnPlugin\Application\Factory\ReturnRequestFactory',
        'Sylius\Plus\Returns\Application\Factory\ReplacementOrderFactory' => 'Sylius\ReturnPlugin\Application\Factory\ReplacementOrderFactory',
        'Sylius\Plus\Returns\Application\Factory\ReplacementOrderFactoryInterface' => 'Sylius\ReturnPlugin\Application\Factory\ReplacementOrderFactoryInterface',
        'Sylius\Plus\Returns\Application\Factory\ReplacementOrderItemFactory' => 'Sylius\ReturnPlugin\Application\Factory\ReplacementOrderItemFactory',
        'Sylius\Plus\Returns\Application\Factory\ReturnRequestUnitFactoryInterface' => 'Sylius\ReturnPlugin\Application\Factory\ReturnRequestUnitFactoryInterface',
        'Sylius\Plus\Returns\Application\Factory\ReturnRequestUnitFactory' => 'Sylius\ReturnPlugin\Application\Factory\ReturnRequestUnitFactory',
        'Sylius\Plus\Returns\Application\Factory\ReplacementOrderItemFactoryInterface' => 'Sylius\ReturnPlugin\Application\Factory\ReplacementOrderItemFactoryInterface',
        'Sylius\Plus\Returns\Application\Operator\ReturnInventoryOperatorInterface' => 'Sylius\ReturnPlugin\Application\Operator\ReturnInventoryOperatorInterface',
        'Sylius\Plus\Returns\Application\Operator\ReturnInventoryOperator' => 'Sylius\ReturnPlugin\Application\Operator\ReturnInventoryOperator',
        'Sylius\Plus\Returns\Application\StateResolver\ReturnRequestItemsReturnedToInventoryStateResolverInterface' => 'Sylius\ReturnPlugin\Application\StateResolver\ReturnRequestItemsReturnedToInventoryStateResolverInterface',
        'Sylius\Plus\Returns\Application\StateResolver\ReturnRequestPackageReceivedStateResolver' => 'Sylius\ReturnPlugin\Application\StateResolver\ReturnRequestPackageReceivedStateResolver',
        'Sylius\Plus\Returns\Application\StateResolver\ReturnRequestItemsReturnedToInventoryStateResolver' => 'Sylius\ReturnPlugin\Application\StateResolver\ReturnRequestItemsReturnedToInventoryStateResolver',
        'Sylius\Plus\Returns\Application\StateResolver\ReturnRequestPackageReceivedStateResolverInterface' => 'Sylius\ReturnPlugin\Application\StateResolver\ReturnRequestPackageReceivedStateResolverInterface',
        'Sylius\Plus\Returns\Infrastructure\Ui\Shop\CancelReturnRequestAction' => 'Sylius\ReturnPlugin\Infrastructure\Ui\Shop\CancelReturnRequestAction',
        'Sylius\Plus\Returns\Infrastructure\Ui\Shop\DownloadReturnRequestPdfFileAction' => 'Sylius\ReturnPlugin\Infrastructure\Ui\Shop\DownloadReturnRequestPdfFileAction',
        'Sylius\Plus\Returns\Infrastructure\Ui\Shop\RequestReturnAction' => 'Sylius\ReturnPlugin\Infrastructure\Ui\Shop\RequestReturnAction',
        'Sylius\Plus\Returns\Infrastructure\Ui\Shop\ViewReturnRequestPageAction' => 'Sylius\ReturnPlugin\Infrastructure\Ui\Shop\ViewReturnRequestPageAction',
        'Sylius\Plus\Returns\Infrastructure\Ui\Admin\DownloadReturnRequestPdfFileAction' => 'Sylius\ReturnPlugin\Infrastructure\Ui\Admin\DownloadReturnRequestPdfFileAction',
        'Sylius\Plus\Returns\Infrastructure\Ui\Admin\RejectReturnRequestAction' => 'Sylius\ReturnPlugin\Infrastructure\Ui\Admin\RejectReturnRequestAction',
        'Sylius\Plus\Returns\Infrastructure\Ui\Admin\ReturnUnitsToInventoryAction' => 'Sylius\ReturnPlugin\Infrastructure\Ui\Admin\ReturnUnitsToInventoryAction',
        'Sylius\Plus\Returns\Infrastructure\Ui\Admin\AcceptReturnRequestAction' => 'Sylius\ReturnPlugin\Infrastructure\Ui\Admin\AcceptReturnRequestAction',
        'Sylius\Plus\Returns\Infrastructure\Ui\Admin\RefundUnitsAction' => 'Sylius\ReturnPlugin\Infrastructure\Ui\Admin\RefundUnitsAction',
        'Sylius\Plus\Returns\Infrastructure\Ui\Admin\ReturnReturnedItemsToInventoryAction' => 'Sylius\ReturnPlugin\Infrastructure\Ui\Admin\ReturnReturnedItemsToInventoryAction',
        'Sylius\Plus\Returns\Infrastructure\Ui\Admin\MarkReturnRequestUnitsAsReceivedAction' => 'Sylius\ReturnPlugin\Infrastructure\Ui\Admin\MarkReturnRequestUnitsAsReceivedAction',
        'Sylius\Plus\Returns\Infrastructure\Ui\Admin\ResolveReturnRequestAction' => 'Sylius\ReturnPlugin\Infrastructure\Ui\Admin\ResolveReturnRequestAction',
        'Sylius\Plus\Returns\Infrastructure\Ui\Admin\CreateReplacementOrderAction' => 'Sylius\ReturnPlugin\Infrastructure\Ui\Admin\CreateReplacementOrderAction',
        'Sylius\Plus\Returns\Infrastructure\Ui\Admin\ReturnRateMetricAction' => 'Sylius\ReturnPlugin\Infrastructure\Ui\Admin\ReturnRateMetricAction',
        'Sylius\Plus\Returns\Infrastructure\Ui\Admin\ChangeReturnRequestResolutionAction' => 'Sylius\ReturnPlugin\Infrastructure\Ui\Admin\ChangeReturnRequestResolutionAction',
        'Sylius\Plus\Returns\Infrastructure\Ui\Admin\SplitReturnRequestAction' => 'Sylius\ReturnPlugin\Infrastructure\Ui\Admin\SplitReturnRequestAction',
        'Sylius\Plus\Returns\Infrastructure\Ui\Admin\SelectReturnRequestUnitsAsReceivedAction' => 'Sylius\ReturnPlugin\Infrastructure\Ui\Admin\SelectReturnRequestUnitsAsReceivedAction',
        'Sylius\Plus\Returns\Infrastructure\Ui\Admin\MarkReturnRequestAsRepairedItemsSentAction' => 'Sylius\ReturnPlugin\Infrastructure\Ui\Admin\MarkReturnRequestAsRepairedItemsSentAction',
        'Sylius\Plus\Returns\Infrastructure\Form\DTO\ReturnRequestInterface' => 'Sylius\ReturnPlugin\Infrastructure\Form\DTO\ReturnRequestInterface',
        'Sylius\Plus\Returns\Infrastructure\Form\DTO\ReturnRequestOrderItemUnitInterface' => 'Sylius\ReturnPlugin\Infrastructure\Form\DTO\ReturnRequestOrderItemUnitInterface',
        'Sylius\Plus\Returns\Infrastructure\Form\DTO\ReturnRequest' => 'Sylius\ReturnPlugin\Infrastructure\Form\DTO\ReturnRequest',
        'Sylius\Plus\Returns\Infrastructure\Form\DTO\ReturnRequestOrderItemUnit' => 'Sylius\ReturnPlugin\Infrastructure\Form\DTO\ReturnRequestOrderItemUnit',
        'Sylius\Plus\Returns\Infrastructure\Form\DTO\Factory\ReturnRequestFactoryInterface' => 'Sylius\ReturnPlugin\Infrastructure\Form\DTO\Factory\ReturnRequestFactoryInterface',
        'Sylius\Plus\Returns\Infrastructure\Form\DTO\Factory\ReturnRequestFactory' => 'Sylius\ReturnPlugin\Infrastructure\Form\DTO\Factory\ReturnRequestFactory',
        'Sylius\Plus\Returns\Infrastructure\Form\Extension\ChannelTypeExtension' => 'Sylius\ReturnPlugin\Infrastructure\Form\Extension\ChannelTypeExtension',
        'Sylius\Plus\Returns\Infrastructure\Form\Type\ReplacementOrderType' => 'Sylius\ReturnPlugin\Infrastructure\Form\Type\ReplacementOrderType',
        'Sylius\Plus\Returns\Infrastructure\Form\Type\ReturnRequestType' => 'Sylius\ReturnPlugin\Infrastructure\Form\Type\ReturnRequestType',
        'Sylius\Plus\Returns\Infrastructure\Form\Type\ReturnRequestUnitsChoiceType' => 'Sylius\ReturnPlugin\Infrastructure\Form\Type\ReturnRequestUnitsChoiceType',
        'Sylius\Plus\Returns\Infrastructure\Form\Type\ReturnRequestImageType' => 'Sylius\ReturnPlugin\Infrastructure\Form\Type\ReturnRequestImageType',
        'Sylius\Plus\Returns\Infrastructure\Form\Type\ReturnRequestOrderItemUnitType' => 'Sylius\ReturnPlugin\Infrastructure\Form\Type\ReturnRequestOrderItemUnitType',
        'Sylius\Plus\Returns\Infrastructure\Form\Type\ReplacementOrderItemType' => 'Sylius\ReturnPlugin\Infrastructure\Form\Type\ReplacementOrderItemType',
        'Sylius\Plus\Returns\Infrastructure\Form\Type\ReturnRequestSplitType' => 'Sylius\ReturnPlugin\Infrastructure\Form\Type\ReturnRequestSplitType',
        'Sylius\Plus\Returns\Infrastructure\Form\Type\ReturnRequestResolutionType' => 'Sylius\ReturnPlugin\Infrastructure\Form\Type\ReturnRequestResolutionType',
        'Sylius\Plus\Returns\Infrastructure\Form\Type\ReturnRequestResolutionChoiceType' => 'Sylius\ReturnPlugin\Infrastructure\Form\Type\ReturnRequestResolutionChoiceType',
        'Sylius\Plus\Returns\Infrastructure\Serializer\RequestReturnDenormalizer' => 'Sylius\ReturnPlugin\Infrastructure\Serializer\RequestReturnDenormalizer',
        'Sylius\Plus\Returns\Infrastructure\Validator\ReturnRequestAvailable' => 'Sylius\ReturnPlugin\Infrastructure\Validator\ReturnRequestAvailable',
        'Sylius\Plus\Returns\Infrastructure\Validator\SplitReturnRequestEligibilityValidator' => 'Sylius\ReturnPlugin\Infrastructure\Validator\SplitReturnRequestEligibilityValidator',
        'Sylius\Plus\Returns\Infrastructure\Validator\ReplacementOrderUniqueVariants' => 'Sylius\ReturnPlugin\Infrastructure\Validator\ReplacementOrderUniqueVariants',
        'Sylius\Plus\Returns\Infrastructure\Validator\ReturnRequestContainsOnlyValidUnitsValidator' => 'Sylius\ReturnPlugin\Infrastructure\Validator\ReturnRequestContainsOnlyValidUnitsValidator',
        'Sylius\Plus\Returns\Infrastructure\Validator\ReturnUnitPossibilityValidator' => 'Sylius\ReturnPlugin\Infrastructure\Validator\ReturnUnitPossibilityValidator',
        'Sylius\Plus\Returns\Infrastructure\Validator\ReturnRequestContainsOnlyValidUnits' => 'Sylius\ReturnPlugin\Infrastructure\Validator\ReturnRequestContainsOnlyValidUnits',
        'Sylius\Plus\Returns\Infrastructure\Validator\SplitReturnRequestEligibility' => 'Sylius\ReturnPlugin\Infrastructure\Validator\SplitReturnRequestEligibility',
        'Sylius\Plus\Returns\Infrastructure\Validator\ReplacementOrderItemInStock' => 'Sylius\ReturnPlugin\Infrastructure\Validator\ReplacementOrderItemInStock',
        'Sylius\Plus\Returns\Infrastructure\Validator\SplitReturnRequestUnitsQuantity' => 'Sylius\ReturnPlugin\Infrastructure\Validator\SplitReturnRequestUnitsQuantity',
        'Sylius\Plus\Returns\Infrastructure\Validator\ReturnRequestAvailableValidator' => 'Sylius\ReturnPlugin\Infrastructure\Validator\ReturnRequestAvailableValidator',
        'Sylius\Plus\Returns\Infrastructure\Validator\SplitReturnRequestUnitsEligibility' => 'Sylius\ReturnPlugin\Infrastructure\Validator\SplitReturnRequestUnitsEligibility',
        'Sylius\Plus\Returns\Infrastructure\Validator\ReplacementOrderUniqueVariantsValidator' => 'Sylius\ReturnPlugin\Infrastructure\Validator\ReplacementOrderUniqueVariantsValidator',
        'Sylius\Plus\Returns\Infrastructure\Validator\ReplacementOrderItemInStockValidator' => 'Sylius\ReturnPlugin\Infrastructure\Validator\ReplacementOrderItemInStockValidator',
        'Sylius\Plus\Returns\Infrastructure\Validator\ReturnRequestResolutionChangePossibility' => 'Sylius\ReturnPlugin\Infrastructure\Validator\ReturnRequestResolutionChangePossibility',
        'Sylius\Plus\Returns\Infrastructure\Validator\ReturnRequestResolutionChangePossibilityValidator' => 'Sylius\ReturnPlugin\Infrastructure\Validator\ReturnRequestResolutionChangePossibilityValidator',
        'Sylius\Plus\Returns\Infrastructure\Validator\ResolutionAvailableValidator' => 'Sylius\ReturnPlugin\Infrastructure\Validator\ResolutionAvailableValidator',
        'Sylius\Plus\Returns\Infrastructure\Validator\ResolutionAvailable' => 'Sylius\ReturnPlugin\Infrastructure\Validator\ResolutionAvailable',
        'Sylius\Plus\Returns\Infrastructure\Validator\SplitReturnRequestUnitsEligibilityValidator' => 'Sylius\ReturnPlugin\Infrastructure\Validator\SplitReturnRequestUnitsEligibilityValidator',
        'Sylius\Plus\Returns\Infrastructure\Validator\SplitReturnRequestUnitsQuantityValidator' => 'Sylius\ReturnPlugin\Infrastructure\Validator\SplitReturnRequestUnitsQuantityValidator',
        'Sylius\Plus\Returns\Infrastructure\Validator\ReturnUnitPossibility' => 'Sylius\ReturnPlugin\Infrastructure\Validator\ReturnUnitPossibility',
        'Sylius\Plus\Returns\Infrastructure\Fixture\ReturnRequestFixture' => 'Sylius\ReturnPlugin\Infrastructure\Fixture\ReturnRequestFixture',
        'Sylius\Plus\Returns\Infrastructure\Checker\CsrfChecker' => 'Sylius\ReturnPlugin\Infrastructure\Checker\CsrfChecker',
        'Sylius\Plus\Returns\Infrastructure\Checker\CsrfCheckerInterface' => 'Sylius\ReturnPlugin\Infrastructure\Checker\CsrfCheckerInterface',
        'Sylius\Plus\Returns\Infrastructure\DataTransformer\ReturnRequestIdInputCommandDataTransformer' => 'Sylius\ReturnPlugin\Infrastructure\DataTransformer\ReturnRequestIdInputCommandDataTransformer',
        'Sylius\Plus\Returns\Infrastructure\DataTransformer\RequestReturnInputCommandDataTransformer' => 'Sylius\ReturnPlugin\Infrastructure\DataTransformer\RequestReturnInputCommandDataTransformer',
        'Sylius\Plus\Returns\Infrastructure\Controller\DisplayReturnRequestResolutionFormAction' => 'Sylius\ReturnPlugin\Infrastructure\Controller\DisplayReturnRequestResolutionFormAction',
        'Sylius\Plus\Returns\Infrastructure\Doctrine\QueryItemExtension\OrderMethodsItemExtension' => 'Sylius\ReturnPlugin\Infrastructure\Doctrine\QueryItemExtension\OrderMethodsItemExtension',
        'Sylius\Plus\Returns\Infrastructure\Doctrine\QueryItemExtension\OrderShopUserItemExtension' => 'Sylius\ReturnPlugin\Infrastructure\Doctrine\QueryItemExtension\OrderShopUserItemExtension',
        'Sylius\Plus\Returns\Infrastructure\Doctrine\QueryCollectionExtension\ReturnRequestsByShopUserExtension' => 'Sylius\ReturnPlugin\Infrastructure\Doctrine\QueryCollectionExtension\ReturnRequestsByShopUserExtension',
        'Sylius\Plus\Returns\Infrastructure\Doctrine\ORM\ReturnRequestRepository' => 'Sylius\ReturnPlugin\Infrastructure\Doctrine\ORM\ReturnRequestRepository',
        'Sylius\Plus\Returns\Infrastructure\Doctrine\ORM\ReturnRequestUnitRepository' => 'Sylius\ReturnPlugin\Infrastructure\Doctrine\ORM\ReturnRequestUnitRepository',
        'Sylius\Plus\Returns\Infrastructure\Doctrine\ORM\ReturnRequestUnitRepositoryInterface' => 'Sylius\ReturnPlugin\Infrastructure\Doctrine\ORM\ReturnRequestUnitRepositoryInterface',
        'Sylius\Plus\Returns\Infrastructure\Doctrine\ORM\CountOrderItemUnitsQueryInterface' => 'Sylius\ReturnPlugin\Infrastructure\Doctrine\ORM\CountOrderItemUnitsQueryInterface',
        'Sylius\Plus\Returns\Infrastructure\Doctrine\ORM\ReturnRequestRepositoryInterface' => 'Sylius\ReturnPlugin\Infrastructure\Doctrine\ORM\ReturnRequestRepositoryInterface',
        'Sylius\Plus\Returns\Infrastructure\Doctrine\ORM\CountOrderItemUnitsQuery' => 'Sylius\ReturnPlugin\Infrastructure\Doctrine\ORM\CountOrderItemUnitsQuery',
        'Sylius\Plus\Returns\Infrastructure\Menu\AdminMenuListener' => 'Sylius\ReturnPlugin\Infrastructure\Menu\AdminMenuListener',
        'Sylius\Plus\Returns\Infrastructure\Twig\ReturnRequestExtension' => 'Sylius\ReturnPlugin\Infrastructure\Twig\ReturnRequestExtension',
        'Sylius\Plus\Returns\Domain\Notification\ReturnRequestNotificationSender' => 'Sylius\ReturnPlugin\Domain\Notification\ReturnRequestNotificationSender',
        'Sylius\Plus\Returns\Domain\Notification\ReturnRequestConfirmationSender' => 'Sylius\ReturnPlugin\Domain\Notification\ReturnRequestConfirmationSender',
        'Sylius\Plus\Returns\Domain\Provider\ReturnRequestResolutionsProvider' => 'Sylius\ReturnPlugin\Domain\Provider\ReturnRequestResolutionsProvider',
        'Sylius\Plus\Returns\Domain\Provider\DateTimeProvider' => 'Sylius\ReturnPlugin\Domain\Provider\DateTimeProvider',
        'Sylius\Plus\Returns\Domain\Model\ReturnRequestPdf' => 'Sylius\ReturnPlugin\Domain\Model\ReturnRequestPdf',
        'Sylius\Plus\Returns\Domain\Model\OrderInterface' => 'Sylius\ReturnPlugin\Domain\Model\OrderInterface',
        'Sylius\Plus\Returns\Domain\Model\ReturnRequestsAllowedAwareInterface' => 'Sylius\ReturnPlugin\Domain\Model\ReturnRequestsAllowedAwareInterface',
        'Sylius\Plus\Returns\Domain\Model\ReturnRequestInterface' => 'Sylius\ReturnPlugin\Domain\Model\ReturnRequestInterface',
        'Sylius\Plus\Returns\Domain\Model\ReturnRequestUnitTransitions' => 'Sylius\ReturnPlugin\Domain\Model\ReturnRequestUnitTransitions',
        'Sylius\Plus\Returns\Domain\Model\ReturnRequestImageInterface' => 'Sylius\ReturnPlugin\Domain\Model\ReturnRequestImageInterface',
        'Sylius\Plus\Returns\Domain\Model\ReturnRequestUnitInterface' => 'Sylius\ReturnPlugin\Domain\Model\ReturnRequestUnitInterface',
        'Sylius\Plus\Returns\Domain\Model\ReplacementOrderItemInterface' => 'Sylius\ReturnPlugin\Domain\Model\ReplacementOrderItemInterface',
        'Sylius\Plus\Returns\Domain\Model\ReturnRequestStates' => 'Sylius\ReturnPlugin\Domain\Model\ReturnRequestStates',
        'Sylius\Plus\Returns\Domain\Model\ReturnRequestAwareTrait' => 'Sylius\ReturnPlugin\Domain\Model\ReturnRequestAwareTrait',
        'Sylius\Plus\Returns\Domain\Model\AdjustmentType' => 'Sylius\ReturnPlugin\Domain\Model\AdjustmentType',
        'Sylius\Plus\Returns\Domain\Model\ReturnRequestUnit' => 'Sylius\ReturnPlugin\Domain\Model\ReturnRequestUnit',
        'Sylius\Plus\Returns\Domain\Model\ReturnRequestResolution' => 'Sylius\ReturnPlugin\Domain\Model\ReturnRequestResolution',
        'Sylius\Plus\Returns\Domain\Model\ReturnRequestResolutions' => 'Sylius\ReturnPlugin\Domain\Model\ReturnRequestResolutions',
        'Sylius\Plus\Returns\Domain\Model\ReturnRequest' => 'Sylius\ReturnPlugin\Domain\Model\ReturnRequest',
        'Sylius\Plus\Returns\Domain\Model\ReplacementOrderInterface' => 'Sylius\ReturnPlugin\Domain\Model\ReplacementOrderInterface',
        'Sylius\Plus\Returns\Domain\Model\ReplacementOrderItem' => 'Sylius\ReturnPlugin\Domain\Model\ReplacementOrderItem',
        'Sylius\Plus\Returns\Domain\Model\ReplacementOrder' => 'Sylius\ReturnPlugin\Domain\Model\ReplacementOrder',
        'Sylius\Plus\Returns\Domain\Model\ReturnRequestUnitStates' => 'Sylius\ReturnPlugin\Domain\Model\ReturnRequestUnitStates',
        'Sylius\Plus\Returns\Domain\Model\ReturnRequestImage' => 'Sylius\ReturnPlugin\Domain\Model\ReturnRequestImage',
        'Sylius\Plus\Returns\Domain\Model\ReturnRequestsAllowedAwareTrait' => 'Sylius\ReturnPlugin\Domain\Model\ReturnRequestsAllowedAwareTrait',
        'Sylius\Plus\Returns\Domain\Model\ChannelInterface' => 'Sylius\ReturnPlugin\Domain\Model\ChannelInterface',
        'Sylius\Plus\Returns\Domain\Model\ReturnRequestAwareInterface' => 'Sylius\ReturnPlugin\Domain\Model\ReturnRequestAwareInterface',
        'Sylius\Plus\Returns\Domain\Model\ReturnRequestTransitions' => 'Sylius\ReturnPlugin\Domain\Model\ReturnRequestTransitions',
        'Sylius\Plus\Returns\Domain\Exception\PackackeForReturnRequestCouldNotBeReceived' => 'Sylius\ReturnPlugin\Domain\Exception\PackackeForReturnRequestCouldNotBeReceived',
        'Sylius\Plus\Returns\Domain\Exception\ReturnRequestConfirmationCouldNotBeSent' => 'Sylius\ReturnPlugin\Domain\Exception\ReturnRequestConfirmationCouldNotBeSent',
        'Sylius\Plus\Returns\Domain\Exception\ReturnRequestNotProvided' => 'Sylius\ReturnPlugin\Domain\Exception\ReturnRequestNotProvided',
        'Sylius\Plus\Returns\Domain\Exception\ReturnRequestUnitCouldNotBeMarkedAsReceived' => 'Sylius\ReturnPlugin\Domain\Exception\ReturnRequestUnitCouldNotBeMarkedAsReceived',
        'Sylius\Plus\Returns\Domain\Exception\InvalidReturnRequestResolution' => 'Sylius\ReturnPlugin\Domain\Exception\InvalidReturnRequestResolution',
        'Sylius\Plus\Returns\Domain\Exception\ReturnRequestNotificationCouldNotBeSent' => 'Sylius\ReturnPlugin\Domain\Exception\ReturnRequestNotificationCouldNotBeSent',
        'Sylius\Plus\Returns\Domain\Exception\ReturnRequestNotFound' => 'Sylius\ReturnPlugin\Domain\Exception\ReturnRequestNotFound',
        'Sylius\Plus\Returns\Domain\Exception\RepairedItemsFromReturnRequestCouldNotBeSent' => 'Sylius\ReturnPlugin\Domain\Exception\RepairedItemsFromReturnRequestCouldNotBeSent',
        'Sylius\Plus\Returns\Domain\Exception\ReturnRequestCouldNotBeResolved' => 'Sylius\ReturnPlugin\Domain\Exception\ReturnRequestCouldNotBeResolved',
        'Sylius\Plus\Returns\Domain\Exception\ReturnRequestUnitCouldNotBeReturnedToInventory' => 'Sylius\ReturnPlugin\Domain\Exception\ReturnRequestUnitCouldNotBeReturnedToInventory',
        'Sylius\Plus\Returns\Domain\Exception\OrderNotFound' => 'Sylius\ReturnPlugin\Domain\Exception\OrderNotFound',
        'Sylius\Plus\Returns\Domain\Exception\ReturnRequestInventoryCouldNotBeReturned' => 'Sylius\ReturnPlugin\Domain\Exception\ReturnRequestInventoryCouldNotBeReturned',
        'Sylius\Plus\ChannelAdmin\Tests\Unit\Domain\Model\AdminChannelAwareTraitTest' => 'Sylius\MultiStorePlugin\ChannelAdmin\Tests\Unit\Domain\Model\AdminChannelAwareTraitTest',
        'Sylius\Plus\ChannelAdmin\Application\Checker\ResourceChannelChecker' => 'Sylius\MultiStorePlugin\ChannelAdmin\Application\Checker\ResourceChannelChecker',
        'Sylius\Plus\ChannelAdmin\Application\Checker\ResourceChannelEnabilibityCheckerInterface' => 'Sylius\MultiStorePlugin\ChannelAdmin\Application\Checker\ResourceChannelEnabilibityCheckerInterface',
        'Sylius\Plus\ChannelAdmin\Application\Checker\ChannelAwareResourceChannelChecker' => 'Sylius\MultiStorePlugin\ChannelAdmin\Application\Checker\ChannelAwareResourceChannelChecker',
        'Sylius\Plus\ChannelAdmin\Application\Checker\ProductVariantResourceChannelChecker' => 'Sylius\MultiStorePlugin\ChannelAdmin\Application\Checker\ProductVariantResourceChannelChecker',
        'Sylius\Plus\ChannelAdmin\Application\Checker\ResourceChannelEnabilibityChecker' => 'Sylius\MultiStorePlugin\ChannelAdmin\Application\Checker\ResourceChannelEnabilibityChecker',
        'Sylius\Plus\ChannelAdmin\Application\Checker\ChannelsAwareResourceChannelChecker' => 'Sylius\MultiStorePlugin\ChannelAdmin\Application\Checker\ChannelsAwareResourceChannelChecker',
        'Sylius\Plus\ChannelAdmin\Application\Checker\OrderAwareResourceChannelChecker' => 'Sylius\MultiStorePlugin\ChannelAdmin\Application\Checker\OrderAwareResourceChannelChecker',
        'Sylius\Plus\ChannelAdmin\Application\Provider\AvailableChannelsForAdminProvider' => 'Sylius\MultiStorePlugin\ChannelAdmin\Application\Provider\AvailableChannelsForAdminProvider',
        'Sylius\Plus\ChannelAdmin\Application\Provider\AdminChannelProviderInterface' => 'Sylius\MultiStorePlugin\ChannelAdmin\Application\Provider\AdminChannelProviderInterface',
        'Sylius\Plus\ChannelAdmin\Application\Provider\AdminChannelProvider' => 'Sylius\MultiStorePlugin\ChannelAdmin\Application\Provider\AdminChannelProvider',
        'Sylius\Plus\ChannelAdmin\Application\Provider\SingleResourceProvider' => 'Sylius\MultiStorePlugin\ChannelAdmin\Application\Provider\SingleResourceProvider',
        'Sylius\Plus\ChannelAdmin\Application\Provider\AvailableChannelsForAdminProviderInterface' => 'Sylius\MultiStorePlugin\ChannelAdmin\Application\Provider\AvailableChannelsForAdminProviderInterface',
        'Sylius\Plus\ChannelAdmin\Application\Provider\ResourcesCollectionProvider' => 'Sylius\MultiStorePlugin\ChannelAdmin\Application\Provider\ResourcesCollectionProvider',
        'Sylius\Plus\ChannelAdmin\Application\Factory\ChannelRestrictingNewResourceFactory' => 'Sylius\MultiStorePlugin\ChannelAdmin\Application\Factory\ChannelRestrictingNewResourceFactory',
        'Sylius\Plus\ChannelAdmin\Application\EventListener\AdminUserChannelEnableListener' => 'Sylius\MultiStorePlugin\ChannelAdmin\Application\EventListener\AdminUserChannelEnableListener',
        'Sylius\Plus\ChannelAdmin\Infrastructure\Form\Extension\AdminUserTypeExtension' => 'Sylius\MultiStorePlugin\ChannelAdmin\Infrastructure\Form\Extension\AdminUserTypeExtension',
        'Sylius\Plus\ChannelAdmin\Infrastructure\Form\Extension\ChannelRestrictingProductTypeExtension' => 'Sylius\MultiStorePlugin\ChannelAdmin\Infrastructure\Form\Extension\ChannelRestrictingProductTypeExtension',
        'Sylius\Plus\ChannelAdmin\Infrastructure\Form\Extension\ChannelRestrictingProductVariantGenerationTypeExtension' => 'Sylius\MultiStorePlugin\ChannelAdmin\Infrastructure\Form\Extension\ChannelRestrictingProductVariantGenerationTypeExtension',
        'Sylius\Plus\ChannelAdmin\Infrastructure\Form\Extension\ChannelRestrictingProductVariantTypeExtension' => 'Sylius\MultiStorePlugin\ChannelAdmin\Infrastructure\Form\Extension\ChannelRestrictingProductVariantTypeExtension',
        'Sylius\Plus\ChannelAdmin\Infrastructure\Doctrine\ORM\CustomerListQueryBuilder' => 'Sylius\MultiStorePlugin\ChannelAdmin\Infrastructure\Doctrine\ORM\CustomerListQueryBuilder',
        'Sylius\Plus\ChannelAdmin\Infrastructure\Doctrine\ORM\ChannelRestrictingProductListQueryBuilderInterface' => 'Sylius\MultiStorePlugin\ChannelAdmin\Infrastructure\Doctrine\ORM\ChannelRestrictingProductListQueryBuilderInterface',
        'Sylius\Plus\ChannelAdmin\Infrastructure\Doctrine\ORM\FindLatestCustomersQueryTrait' => 'Sylius\MultiStorePlugin\ChannelAdmin\Infrastructure\Doctrine\ORM\FindLatestCustomersQueryTrait',
        'Sylius\Plus\ChannelAdmin\Infrastructure\Doctrine\ORM\CreditMemoListQueryBuilder' => 'Sylius\MultiStorePlugin\ChannelAdmin\Infrastructure\Doctrine\ORM\CreditMemoListQueryBuilder',
        'Sylius\Plus\ChannelAdmin\Infrastructure\Doctrine\ORM\InvoiceListQueryBuilderInterface' => 'Sylius\MultiStorePlugin\ChannelAdmin\Infrastructure\Doctrine\ORM\InvoiceListQueryBuilderInterface',
        'Sylius\Plus\ChannelAdmin\Infrastructure\Doctrine\ORM\ChannelRestrictingProductListQueryBuilder' => 'Sylius\MultiStorePlugin\ChannelAdmin\Infrastructure\Doctrine\ORM\ChannelRestrictingProductListQueryBuilder',
        'Sylius\Plus\ChannelAdmin\Infrastructure\Doctrine\ORM\CreateOrderListQueryBuilderTrait' => 'Sylius\MultiStorePlugin\ChannelAdmin\Infrastructure\Doctrine\ORM\CreateOrderListQueryBuilderTrait',
        'Sylius\Plus\ChannelAdmin\Infrastructure\Doctrine\ORM\CustomerListQueryBuilderInterface' => 'Sylius\MultiStorePlugin\ChannelAdmin\Infrastructure\Doctrine\ORM\CustomerListQueryBuilderInterface',
        'Sylius\Plus\ChannelAdmin\Infrastructure\Doctrine\ORM\CreateShipmentListQueryBuilderTrait' => 'Sylius\MultiStorePlugin\ChannelAdmin\Infrastructure\Doctrine\ORM\CreateShipmentListQueryBuilderTrait',
        'Sylius\Plus\ChannelAdmin\Infrastructure\Doctrine\ORM\InvoiceListQueryBuilder' => 'Sylius\MultiStorePlugin\ChannelAdmin\Infrastructure\Doctrine\ORM\InvoiceListQueryBuilder',
        'Sylius\Plus\ChannelAdmin\Infrastructure\Doctrine\ORM\FindProductsByChannelAndPhraseQueryInterface' => 'Sylius\LoyaltyPlugin\Infrastructure\Doctrine\ORM\FindProductsByChannelAndPhraseQueryInterface',
        'Sylius\Plus\ChannelAdmin\Infrastructure\Doctrine\ORM\CreditMemoListQueryBuilderInterface' => 'Sylius\MultiStorePlugin\ChannelAdmin\Infrastructure\Doctrine\ORM\CreditMemoListQueryBuilderInterface',
        'Sylius\Plus\ChannelAdmin\Infrastructure\Doctrine\ORM\FindProductsByChannelAndPhraseQuery' => 'Sylius\MultiStorePlugin\ChannelAdmin\Infrastructure\Doctrine\ORM\FindProductsByChannelAndPhraseQuery',
        'Sylius\Plus\ChannelAdmin\Infrastructure\Doctrine\ORM\CreatePaymentListQueryBuilderTrait' => 'Sylius\MultiStorePlugin\ChannelAdmin\Infrastructure\Doctrine\ORM\CreatePaymentListQueryBuilderTrait',
        'Sylius\Plus\ChannelAdmin\Infrastructure\Doctrine\Filter\AdminUserChannelFilter' => 'Sylius\MultiStorePlugin\ChannelAdmin\Infrastructure\Doctrine\Filter\AdminUserChannelFilter',
        'Sylius\Plus\ChannelAdmin\Infrastructure\Twig\AdminChannelExtension' => 'Sylius\MultiStorePlugin\ChannelAdmin\Infrastructure\Twig\AdminChannelExtension',
        'Sylius\Plus\ChannelAdmin\Domain\Model\AdminChannelAwareTrait' => 'Sylius\MultiStorePlugin\ChannelAdmin\Domain\Model\AdminChannelAwareTrait',
    ]);
};
