<?php

/*
 * This file is part of the Sylius package.
 *
 * (c) Sylius Sp. z o.o.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace Sylius\Resource\Model;

use Webmozart\Assert\Assert;

class AbstractTranslation implements TranslationInterface
{
    protected ?string $locale = null;

    protected ?TranslatableInterface $translatable = null;

    public function getTranslatable(): TranslatableInterface
    {
        $translatable = $this->translatable;

        // Return typehint should account for null value.
        Assert::notNull($translatable);

        return $translatable;
    }

    public function setTranslatable(?TranslatableInterface $translatable): void
    {
        if ($translatable === $this->translatable) {
            return;
        }

        $previousTranslatable = $this->translatable;
        $this->translatable = $translatable;

        if (null !== $previousTranslatable) {
            $previousTranslatable->removeTranslation($this);
        }

        if (null !== $translatable) {
            $translatable->addTranslation($this);
        }
    }

    public function getLocale(): ?string
    {
        return $this->locale;
    }

    public function setLocale(?string $locale): void
    {
        $this->locale = $locale;
    }
}

class_alias(AbstractTranslation::class, \Sylius\Component\Resource\Model\AbstractTranslation::class);
