<?php

/*
 * This file is part of the Sylius package.
 *
 * (c) Sylius Sp. z o.o.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace Sylius\Resource\Generator;

interface RandomnessGeneratorInterface
{
    public function generateUriSafeString(int $length): string;

    public function generateNumeric(int $length): string;

    public function generateInt(int $min, int $max): int;
}

class_alias(RandomnessGeneratorInterface::class, \Sylius\Component\Resource\Generator\RandomnessGeneratorInterface::class);
