# Installation

We assume you're familiar with [Composer](http://packagist.org), a dependency manager for PHP.
Use the following command to add the bundle to your `composer.json` and download the package.

If you have [Composer installed globally](http://getcomposer.org/doc/00-intro.md#globally).

```bash
composer require sylius/mailer-bundle
```
Otherwise you have to download .phar file.

```bash
curl -sS https://getcomposer.org/installer | php
php composer.phar require sylius/mailer-bundle
```
# Adding required bundles to the kernel

You need to enable the bundle inside the kernel.

```php
// config/bundles.php

return [
    new winzou\Bundle\StateMachineBundle\winzouStateMachineBundle(),
    new FOS\RestBundle\FOSRestBundle(),
    new JMS\SerializerBundle\JMSSerializerBundle($this),
    new Stof\DoctrineExtensionsBundle\StofDoctrineExtensionsBundle(),
    new WhiteOctober\PagerfantaBundle\WhiteOctoberPagerfantaBundle(),

    new Sylius\Bundle\MailerBundle\SyliusMailerBundle(),
];
```
# Container configuration

Put this configuration inside your ``config/packages/sylius_mailer.yaml``.

```yaml
sylius_mailer:
    sender:
        name: My website
        address: no-reply@my-website.com
```

Congratulations! The bundle is now installed and ready to use.

**[Go back to the documentation's index](index.md)**

