<?php

namespace Payum\Bundle\PayumBundle\Tests\Form\Type;

use Payum\Bundle\PayumBundle\Form\Type\CreditCardExpirationDateType;
use PHPUnit\Framework\TestCase;
use ReflectionClass;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\OptionsResolver\OptionsResolver;

class CreditCardExpirationDateTypeTest extends TestCase
{
    public function testShouldBeSubClassOfAbstractType(): void
    {
        $rc = new ReflectionClass(CreditCardExpirationDateType::class);

        $this->assertTrue($rc->isSubclassOf(AbstractType::class));
    }

    public function testShouldExtendDateType(): void
    {
        $type = new CreditCardExpirationDateType();

        $this->assertSame(DateType::class, $type->getParent());
    }

    public function testShouldAllowResolveOptions(): void
    {
        $type = new CreditCardExpirationDateType();

        $resolver = new OptionsResolver();

        $type->configureOptions($resolver);

        $options = $resolver->resolve();

        $this->assertArrayHasKey('years', $options);
        $this->assertCount(11, $options['years']);

        $this->assertArrayHasKey('min_expiration_year', $options);
        $this->assertEquals(date('Y'), $options['min_expiration_year']);

        $this->assertArrayHasKey('max_expiration_year', $options);
        $this->assertEquals(date('Y') + 10, $options['max_expiration_year']);
    }

    public function testShouldTakeMinAndMaxExpirationYearsWhileCalcYearsRange(): void
    {
        $type = new CreditCardExpirationDateType();

        $resolver = new OptionsResolver();

        $type->configureOptions($resolver);

        $options = $resolver->resolve([
            'min_expiration_year' => 2000,
            'max_expiration_year' => 2002,
        ]);

        $this->assertArrayHasKey('years', $options);
        $this->assertCount(3, $options['years']);

        $this->assertArrayHasKey('min_expiration_year', $options);
        $this->assertSame(2000, $options['min_expiration_year']);

        $this->assertArrayHasKey('max_expiration_year', $options);
        $this->assertSame(2002, $options['max_expiration_year']);
    }
}
