# Halite Documentation

1. [Basic Halite Usage](Basic.md)
2. [Halite Features](Features.md)
3. [Cryptography Primitives](Primitives.md)
4. [Class Documentation](Classes/)

## Class Documentation

* [`Alerts`](Classes/Alerts) (Exceptions)
  * [`\ParagonIE\Halite\Alerts\CannotCloneKey`](Classes/Alerts/CannotCloneKey.md)
  * [`\ParagonIE\Halite\Alerts\CannotPerformOperation`](Classes/Alerts/CannotPerformOperation.md)
  * [`\ParagonIE\Halite\Alerts\CannotSerializeKey`](Classes/Alerts/CannotSerializeKey.md)
  * [`\ParagonIE\Halite\Alerts\ConfigDirectiveNotFound`](Classes/Alerts/ConfigDirectiveNotFound.md)
  * [`\ParagonIE\Halite\Alerts\FileAccessDenied`](Classes/Alerts/FileAccessDenied.md)
  * [`\ParagonIE\Halite\Alerts\FileError`](Classes/Alerts/FileError.md)
  * [`\ParagonIE\Halite\Alerts\FileModified`](Classes/Alerts/FileModified.md)
  * [`\ParagonIE\Halite\Alerts\HaliteAlert`](Classes/Alerts/HaliteAlert.md) (Base Exception for all Alerts)
  * [`\ParagonIE\Halite\Alerts\HaliteAlertInterface`](Classes/Alerts/HaliteAlertInterface.md) (Common Interface)
  * [`\ParagonIE\Halite\Alerts\InvalidDigestLength`](Classes/Alerts/InvalidDigestLength.md)
  * [`\ParagonIE\Halite\Alerts\InvalidFlags`](Classes/Alerts/InvalidFlags.md)
  * [`\ParagonIE\Halite\Alerts\InvalidKey`](Classes/Alerts/InvalidKey.md)
  * [`\ParagonIE\Halite\Alerts\InvalidMessage`](Classes/Alerts/InvalidMessage.md)
  * [`\ParagonIE\Halite\Alerts\InvalidSalt`](Classes/Alerts/InvalidSalt.md)
  * [`\ParagonIE\Halite\Alerts\InvalidSignature`](Classes/Alerts/InvalidSignature.md)
  * [`\ParagonIE\Halite\Alerts\InvalidType`](Classes/Alerts/InvalidType.md)
* [`Asymmetric`](Classes/Asymmetric)
  * [`\ParagonIE\Halite\Asymmetric\Crypto`](Classes/Asymmetric/Crypto.md)
  * [`\ParagonIE\Halite\Asymmetric\EncryptionPublicKey`](Classes/Asymmetric/EncryptionPublicKey.md)
  * [`\ParagonIE\Halite\Asymmetric\EncryptionSecretKey`](Classes/Asymmetric/EncryptionSecretKey.md)
  * [`\ParagonIE\Halite\Asymmetric\PublicKey`](Classes/Asymmetric/PublicKey.md)
  * [`\ParagonIE\Halite\Asymmetric\SecretKey`](Classes/Asymmetric/SecretKey.md)
  * [`\ParagonIE\Halite\Asymmetric\SignaturePublicKey`](Classes/Asymmetric/SignaturePublicKey.md)
  * [`\ParagonIE\Halite\Asymmetric\SignatureSecretKey`](Classes/Asymmetric/SignatureSecretKey.md)
* [`Contract`](Classes/Contract) (Interfaces)
  * [`\ParagonIE\Halite\Contract\StreamInterface`](Classes/Contract/StreamInterface.md)
* [`Stream`](Classes/Stream)
  * [`\ParagonIE\Halite\Stream\MutableFile`](Classes/Stream/MutableFile.md)
  * [`\ParagonIE\Halite\Stream\ReadOnlyFile`](Classes/Stream/ReadOnlyFile.md)
  * [`\ParagonIE\Halite\Stream\WeakReadOnlyFile`](Classes/Stream/WeakReadOnlyFile.md)
* [`Structure`](Classes/Classes/Structure)
  * [`\ParagonIE\Halite\Structure\BlockChain`](Classes/Stream/BlockChain.md)
  * [`\ParagonIE\Halite\Structure\MerkleTree`](Classes/Stream/MerkleTree.md)
  * [`\ParagonIE\Halite\Structure\Node`](Classes/Stream/Node.md)
* [`Symmetric`](Classes/Symmetric)
  * [`\ParagonIE\Halite\Symmetric\AuthenticationKey`](Classes/Symmetric/AuthenticationKey.md)
  * [`\ParagonIE\Halite\Symmetric\Config`](Classes/Symmetric/Config.md)
  * [`\ParagonIE\Halite\Symmetric\Crypto`](Classes/Symmetric/Crypto.md)
  * [`\ParagonIE\Halite\Symmetric\EncryptionKey`](Classes/Symmetric/EncryptionKey.md)
  * [`\ParagonIE\Halite\Symmetric\SecretKey`](Classes/Symmetric/SecretKey.md)
* [`\ParagonIE\Halite\Config`](Config.md)
* [`\ParagonIE\Halite\Cookie`](Classes/Cookie.md)
* [`\ParagonIE\Halite\EncryptionKeyPair`](Classes/EncryptionKeyPair.md)
* [`\ParagonIE\Halite\File`](Classes/File.md)
* [`\ParagonIE\Halite\Halite`](Classes/Halite.md)
* [`\ParagonIE\Halite\Key`](Classes/Key.md)
* [`\ParagonIE\Halite\KeyFactory`](Classes/KeyFactory.md)
* [`\ParagonIE\Halite\KeyPair`](Classes/KeyPair.md)
* [`\ParagonIE\Halite\Password`](Classes/Password.md)
* [`\ParagonIE\Halite\SignatureKeyPair`](Classes/SignatureKeyPair.md)
* [`\ParagonIE\Halite\Util`](Classes/Util.md)
