"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.trim = exports.get = void 0;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var trim = exports.trim = function trim(str) {
  var chars = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : ' \f\n\r\t\v';
  while (chars.indexOf(str[0]) >= 0) {
    str = str.slice(1);
  }
  while (chars.indexOf(str[str.length - 1]) >= 0) {
    str = str.slice(0, -1);
  }
  return str;
};
var get = exports.get = function () {
  var re = new RegExp(/[\w\-]+|\[[^\]]*\]+/g);
  return function (object, path, defaultValue) {
    if (!object || _typeof(object) !== 'object') {
      return defaultValue;
    }
    path = '' + path;
    var keys = path.match(re);
    if (!keys) {
      return defaultValue;
    }
    for (var i = 0; i < keys.length; i++) {
      var key = keys[i];
      key = trim(key, ' \f\n\r\t\v');
      if (key[0] === '[') {
        key = trim(key.slice(1, -1), ' \f\n\r\t\v');
      }
      key = trim(key, '\'"');
      if (object === undefined || object === null || _typeof(object) !== 'object') {
        break;
      }
      object = object[key];
      if (object === undefined) {
        break;
      }
    }
    return object !== undefined ? object : defaultValue;
  };
}();