"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultRowRenderer = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _escapeHtml = _interopRequireDefault(require("escape-html"));
var _html5Tag = _interopRequireDefault(require("html5-tag"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
/* eslint import/prefer-default-export: 0 */

var defaultRowRenderer = exports.defaultRowRenderer = function defaultRowRenderer(node, treeOptions) {
  var id = node.id,
    name = node.name,
    _node$loadOnDemand = node.loadOnDemand,
    loadOnDemand = _node$loadOnDemand === void 0 ? false : _node$loadOnDemand,
    children = node.children,
    state = node.state;
  var droppable = treeOptions.droppable;
  var depth = state.depth,
    open = state.open,
    path = state.path,
    total = state.total,
    _state$selected = state.selected,
    selected = _state$selected === void 0 ? false : _state$selected,
    filtered = state.filtered;
  var childrenLength = Object.keys(children).length;
  var more = node.hasChildren();
  if (filtered === false) {
    return '';
  }
  var togglerContent = '';
  if (!more && loadOnDemand) {
    togglerContent = '►';
  }
  if (more && open) {
    togglerContent = '▼';
  }
  if (more && !open) {
    togglerContent = '►';
  }
  var toggler = (0, _html5Tag["default"])('a', {
    'class': function () {
      if (!more && loadOnDemand) {
        return (0, _classnames["default"])(treeOptions.togglerClass, 'infinite-tree-closed');
      }
      if (more && open) {
        return (0, _classnames["default"])(treeOptions.togglerClass);
      }
      if (more && !open) {
        return (0, _classnames["default"])(treeOptions.togglerClass, 'infinite-tree-closed');
      }
      return '';
    }()
  }, togglerContent);
  var title = (0, _html5Tag["default"])('span', {
    'class': (0, _classnames["default"])('infinite-tree-title')
  }, (0, _escapeHtml["default"])(name));
  var treeNode = (0, _html5Tag["default"])('div', {
    'class': 'infinite-tree-node',
    'style': "margin-left: ".concat(depth * 18, "px")
  }, toggler + title);
  return (0, _html5Tag["default"])('div', {
    'data-id': id,
    'data-expanded': more && open,
    'data-depth': depth,
    'data-path': path,
    'data-selected': selected,
    'data-children': childrenLength,
    'data-total': total,
    'class': (0, _classnames["default"])('infinite-tree-item', {
      'infinite-tree-selected': selected
    }),
    'droppable': droppable
  }, treeNode);
};