"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
/**
 * Remove a range of items from an array.
 *
 * @function removeItems
 * @param {Array<*>} arr The target array.
 * @param {number} startIndex The index to begin removing from (inclusive).
 * @param {number} removeCount How many items to remove.
 */
var removeArrayItems = function removeArrayItems(arr, startIndex, removeCount) {
  var length = arr.length;
  if (startIndex >= length || removeCount <= 0 || startIndex < 0) {
    return;
  }
  removeCount = startIndex + removeCount > length ? length - startIndex : removeCount;
  var len = length - removeCount;
  for (var i = startIndex; i < len; ++i) {
    arr[i] = arr[i + removeCount];
  }
  arr.length = len;
};
var _default = exports["default"] = removeArrayItems;