"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _events = _interopRequireDefault(require("events"));
var _classnames = _interopRequireDefault(require("classnames"));
var _elementClass = _interopRequireDefault(require("element-class"));
var _isDom = _interopRequireDefault(require("is-dom"));
var _flattree = require("flattree");
var _clusterize = _interopRequireDefault(require("./clusterize"));
var _ensureArray = _interopRequireDefault(require("./ensure-array"));
var _extend = _interopRequireDefault(require("./extend"));
var _lookupTable = _interopRequireDefault(require("./lookup-table"));
var _removeArrayItems = _interopRequireDefault(require("./remove-array-items"));
var _renderer = require("./renderer");
var _utilities = require("./utilities");
var _dom = require("./dom");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /* eslint no-continue: 0 */ /* eslint operator-assignment: 0 */
var noop = function noop() {};
var error = function error(format) {
  for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    args[_key - 1] = arguments[_key];
  }
  var argIndex = 0;
  var message = 'Error: ' + format.replace(/%s/g, function () {
    return args[argIndex++];
  });
  if (console && console.error) {
    console.error(message);
  }
  try {
    // This error was thrown as a convenience so that you can use this stack
    // to find the callsite that caused this error to fire.
    throw new Error(message);
  } catch (e) {
    // Ignore
  }
};
var ensureNodeInstance = function ensureNodeInstance(node) {
  if (!node) {
    // undefined or null
    return false;
  }
  if (!(node instanceof _flattree.Node)) {
    error('The node must be a Node object.');
    return false;
  }
  return true;
};
var createRootNode = function createRootNode(rootNode) {
  return (0, _extend["default"])(rootNode || new _flattree.Node(), {
    parent: null,
    children: [],
    state: {
      depth: -1,
      open: true,
      // always open
      path: '',
      prefixMask: '',
      total: 0
    }
  });
};
var InfiniteTree = /*#__PURE__*/function (_events$EventEmitter) {
  // Creates new InfiniteTree object.
  function InfiniteTree(el, options) {
    var _this;
    _classCallCheck(this, InfiniteTree);
    _this = _callSuper(this, InfiniteTree);
    _defineProperty(_this, "options", {
      autoOpen: false,
      droppable: false,
      shouldLoadNodes: null,
      loadNodes: null,
      rowRenderer: _renderer.defaultRowRenderer,
      selectable: true,
      shouldSelectNode: null,
      // Allow user to define the number of rows, and blocks to be rendered.
      rowsInBlock: 50,
      blocksInCluster: 4,
      // When el is not specified, the tree will run in the stealth mode
      el: null,
      // The following options will have no effect in the stealth mode
      layout: 'div',
      noDataClass: 'infinite-tree-no-data',
      noDataText: 'No data',
      nodeIdAttr: 'data-id',
      togglerClass: 'infinite-tree-toggler'
    });
    _defineProperty(_this, "state", {
      openNodes: [],
      rootNode: createRootNode(),
      selectedNode: null
    });
    _defineProperty(_this, "clusterize", null);
    _defineProperty(_this, "nodeTable", new _lookupTable["default"]());
    _defineProperty(_this, "nodes", []);
    _defineProperty(_this, "rows", []);
    _defineProperty(_this, "filtered", false);
    // The following elements will have no effect in the stealth mode
    _defineProperty(_this, "scrollElement", null);
    _defineProperty(_this, "contentElement", null);
    _defineProperty(_this, "draggableTarget", null);
    _defineProperty(_this, "droppableTarget", null);
    _defineProperty(_this, "contentListener", {
      'click': function click(event) {
        event = event || window.event;

        // Wrap stopPropagation that allows click event handler to stop execution
        // by setting the cancelBubble property
        var stopPropagation = event.stopPropagation;
        event.stopPropagation = function () {
          // Setting the cancelBubble property in browsers that don't support it doesn't hurt.
          // Of course it doesn't actually cancel the bubbling, but the assignment itself is safe.
          event.cancelBubble = true;
          if (stopPropagation) {
            stopPropagation.call(event);
          }
        };

        // Call setTimeout(fn, 0) to re-queues the execution of subsequent calls, it allows the
        // click event to bubble up to higher level event handlers before handling tree events.
        setTimeout(function () {
          // Stop execution if the cancelBubble property is set to true by higher level event handlers
          if (event.cancelBubble === true) {
            return;
          }

          // Emit a "click" event
          _this.emit('click', event);

          // Stop execution if the cancelBubble property is set to true after emitting the click event
          if (event.cancelBubble === true) {
            return;
          }
          var itemTarget = null;
          var clickToggler = false;
          if (event.target) {
            itemTarget = event.target !== event.currentTarget ? event.target : null;
          } else if (event.srcElement) {
            // IE8
            itemTarget = event.srcElement;
          }
          while (itemTarget && itemTarget.parentElement !== _this.contentElement) {
            if ((0, _elementClass["default"])(itemTarget).has(_this.options.togglerClass)) {
              clickToggler = true;
            }
            itemTarget = itemTarget.parentElement;
          }
          if (!itemTarget || itemTarget.hasAttribute('disabled')) {
            return;
          }
          var id = itemTarget.getAttribute(_this.options.nodeIdAttr);
          var node = _this.getNodeById(id);
          if (!node) {
            return;
          }

          // Click on the toggler to open/close a tree node
          if (clickToggler) {
            _this.toggleNode(node, {
              async: true
            });
            return;
          }
          _this.selectNode(node); // selectNode will re-render the tree
        }, 0);
      },
      'dblclick': function dblclick(event) {
        // Emit a "doubleClick" event
        _this.emit('doubleClick', event);
      },
      'keydown': function keydown(event) {
        // Emit a "keyDown" event
        _this.emit('keyDown', event);
      },
      'keyup': function keyup(event) {
        // Emit a "keyUp" event
        _this.emit('keyUp', event);
      },
      // https://developer.mozilla.org/en-US/docs/Web/Events/dragstart
      // The dragstart event is fired when the user starts dragging an element or text selection.
      'dragstart': function dragstart(event) {
        event = event || window.event;
        _this.draggableTarget = event.target || event.srcElement;
      },
      // https://developer.mozilla.org/en-US/docs/Web/Events/dragend
      // The dragend event is fired when a drag operation is being ended (by releasing a mouse button or hitting the escape key).
      'dragend': function dragend(event) {
        event = event || window.event;
        var _this$options$droppab = _this.options.droppable.hoverClass,
          hoverClass = _this$options$droppab === void 0 ? '' : _this$options$droppab;

        // Draggable
        _this.draggableTarget = null;

        // Droppable
        if (_this.droppableTarget) {
          (0, _elementClass["default"])(_this.droppableTarget).remove(hoverClass);
          _this.droppableTarget = null;
        }
      },
      // https://developer.mozilla.org/en-US/docs/Web/Events/dragenter
      // The dragenter event is fired when a dragged element or text selection enters a valid drop target.
      'dragenter': function dragenter(event) {
        event = event || window.event;
        var itemTarget = null;
        if (event.target) {
          itemTarget = event.target !== event.currentTarget ? event.target : null;
        } else if (event.srcElement) {
          // IE8
          itemTarget = event.srcElement;
        }
        while (itemTarget && itemTarget.parentElement !== _this.contentElement) {
          itemTarget = itemTarget.parentElement;
        }
        if (!itemTarget) {
          return;
        }
        if (_this.droppableTarget === itemTarget) {
          return;
        }
        var _this$options$droppab2 = _this.options.droppable,
          accept = _this$options$droppab2.accept,
          _this$options$droppab3 = _this$options$droppab2.hoverClass,
          hoverClass = _this$options$droppab3 === void 0 ? '' : _this$options$droppab3;
        (0, _elementClass["default"])(_this.droppableTarget).remove(hoverClass);
        _this.droppableTarget = null;
        var canDrop = true; // Defaults to true

        if (typeof accept === 'function') {
          var id = itemTarget.getAttribute(_this.options.nodeIdAttr);
          var node = _this.getNodeById(id);
          canDrop = !!accept.call(_this, event, {
            type: 'dragenter',
            draggableTarget: _this.draggableTarget,
            droppableTarget: itemTarget,
            node: node
          });
        }
        if (canDrop) {
          (0, _elementClass["default"])(itemTarget).add(hoverClass);
          _this.droppableTarget = itemTarget;
        }
      },
      // https://developer.mozilla.org/en-US/docs/Web/Events/dragover
      // The dragover event is fired when an element or text selection is being dragged over a valid drop target (every few hundred milliseconds).
      'dragover': function dragover(event) {
        event = event || window.event;
        (0, _dom.preventDefault)(event);
      },
      // https://developer.mozilla.org/en-US/docs/Web/Events/drop
      // The drop event is fired when an element or text selection is dropped on a valid drop target.
      'drop': function drop(event) {
        event = event || window.event;

        // prevent default action (open as link for some elements)
        (0, _dom.preventDefault)(event);
        if (!(_this.draggableTarget && _this.droppableTarget)) {
          return;
        }
        var _this$options$droppab4 = _this.options.droppable,
          accept = _this$options$droppab4.accept,
          drop = _this$options$droppab4.drop,
          _this$options$droppab5 = _this$options$droppab4.hoverClass,
          hoverClass = _this$options$droppab5 === void 0 ? '' : _this$options$droppab5;
        var id = _this.droppableTarget.getAttribute(_this.options.nodeIdAttr);
        var node = _this.getNodeById(id);
        var canDrop = true; // Defaults to true

        if (typeof accept === 'function') {
          canDrop = !!accept.call(_this, event, {
            type: 'drop',
            draggableTarget: _this.draggableTarget,
            droppableTarget: _this.droppableTarget,
            node: node
          });
        }
        if (canDrop && typeof drop === 'function') {
          drop.call(_this, event, {
            draggableTarget: _this.draggableTarget,
            droppableTarget: _this.droppableTarget,
            node: node
          });
        }
        (0, _elementClass["default"])(_this.droppableTarget).remove(hoverClass);
        _this.droppableTarget = null;
      }
    });
    if ((0, _isDom["default"])(el)) {
      options = _objectSpread(_objectSpread({}, options), {}, {
        el: el
      });
    } else if (el && _typeof(el) === 'object') {
      options = el;
    }

    // Assign options
    _this.options = _objectSpread(_objectSpread({}, _this.options), options);
    _this.create();

    // Load tree data if it's provided
    if (_this.options.data) {
      _this.loadData(_this.options.data);
    }
    return _this;
  }
  _inherits(InfiniteTree, _events$EventEmitter);
  return _createClass(InfiniteTree, [{
    key: "create",
    value: function create() {
      var _this2 = this;
      if (this.options.el) {
        var tag = null;
        this.scrollElement = document.createElement('div');
        if (this.options.layout === 'table') {
          var tableElement = document.createElement('table');
          tableElement.className = (0, _classnames["default"])('infinite-tree', 'infinite-tree-table');
          var contentElement = document.createElement('tbody');
          tableElement.appendChild(contentElement);
          this.scrollElement.appendChild(tableElement);
          this.contentElement = contentElement;

          // The tag name for supporting elements
          tag = 'tr';
        } else {
          var _contentElement = document.createElement('div');
          this.scrollElement.appendChild(_contentElement);
          this.contentElement = _contentElement;

          // The tag name for supporting elements
          tag = 'div';
        }
        this.scrollElement.className = (0, _classnames["default"])('infinite-tree', 'infinite-tree-scroll');
        this.contentElement.className = (0, _classnames["default"])('infinite-tree', 'infinite-tree-content');
        this.options.el.appendChild(this.scrollElement);
        this.clusterize = new _clusterize["default"]({
          tag: tag,
          rows: [],
          scrollElement: this.scrollElement,
          contentElement: this.contentElement,
          emptyText: this.options.noDataText,
          emptyClass: this.options.noDataClass,
          rowsInBlock: this.options.rowsInBlock,
          blocksInCluster: this.options.blocksInCluster
        });
        this.clusterize.on('clusterWillChange', function () {
          _this2.emit('clusterWillChange');
        });
        this.clusterize.on('clusterDidChange', function () {
          _this2.emit('clusterDidChange');
        });
        (0, _dom.addEventListener)(this.contentElement, 'click', this.contentListener.click);
        (0, _dom.addEventListener)(this.contentElement, 'dblclick', this.contentListener.dblclick);
        (0, _dom.addEventListener)(this.contentElement, 'keydown', this.contentListener.keydown);
        (0, _dom.addEventListener)(this.contentElement, 'keyup', this.contentListener.keyup);
        if (this.options.droppable) {
          (0, _dom.addEventListener)(document, 'dragstart', this.contentListener.dragstart);
          (0, _dom.addEventListener)(document, 'dragend', this.contentListener.dragend);
          (0, _dom.addEventListener)(this.contentElement, 'dragenter', this.contentListener.dragenter);
          (0, _dom.addEventListener)(this.contentElement, 'dragleave', this.contentListener.dragleave);
          (0, _dom.addEventListener)(this.contentElement, 'dragover', this.contentListener.dragover);
          (0, _dom.addEventListener)(this.contentElement, 'drop', this.contentListener.drop);
        }
      }
    }
  }, {
    key: "destroy",
    value: function destroy() {
      this.clear();
      if (this.options.el) {
        (0, _dom.removeEventListener)(this.contentElement, 'click', this.contentListener.click);
        (0, _dom.removeEventListener)(this.contentElement, 'dblclick', this.contentListener.dblclick);
        (0, _dom.removeEventListener)(this.contentElement, 'keydown', this.contentListener.keydown);
        (0, _dom.removeEventListener)(this.contentElement, 'keyup', this.contentListener.keyup);
        if (this.options.droppable) {
          (0, _dom.removeEventListener)(document, 'dragstart', this.contentListener.dragstart);
          (0, _dom.removeEventListener)(document, 'dragend', this.contentListener.dragend);
          (0, _dom.removeEventListener)(this.contentElement, 'dragenter', this.contentListener.dragenter);
          (0, _dom.removeEventListener)(this.contentElement, 'dragleave', this.contentListener.dragleave);
          (0, _dom.removeEventListener)(this.contentElement, 'dragover', this.contentListener.dragover);
          (0, _dom.removeEventListener)(this.contentElement, 'drop', this.contentListener.drop);
        }
        if (this.clusterize) {
          this.clusterize.destroy(true); // True to remove all data from the list
          this.clusterize = null;
        }

        // Remove all child nodes
        while (this.contentElement.firstChild) {
          this.contentElement.removeChild(this.contentElement.firstChild);
        }
        while (this.scrollElement.firstChild) {
          this.scrollElement.removeChild(this.scrollElement.firstChild);
        }
        var containerElement = this.options.el;
        while (containerElement.firstChild) {
          containerElement.removeChild(containerElement.firstChild);
        }
        this.contentElement = null;
        this.scrollElement = null;
      }
    }

    // Adds an array of new child nodes to a parent node at the specified index.
    // * If the parent is null or undefined, inserts new childs at the specified index in the top-level.
    // * If the parent has children, the method adds the new child to it at the specified index.
    // * If the parent does not have children, the method adds the new child to the parent.
    // * If the index value is greater than or equal to the number of children in the parent, the method adds the child at the end of the children.
    // @param {Array} newNodes An array of new child nodes.
    // @param {number} [index] The 0-based index of where to insert the child node.
    // @param {Node} parentNode The Node object that defines the parent node.
    // @return {boolean} Returns true on success, false otherwise.
  }, {
    key: "addChildNodes",
    value: function addChildNodes(newNodes, index, parentNode) {
      var _this3 = this;
      newNodes = [].concat(newNodes || []); // Ensure array
      if (newNodes.length === 0) {
        return false;
      }
      if (_typeof(index) === 'object') {
        // The 'object' type might be Node or null
        parentNode = index || this.state.rootNode; // Defaults to rootNode if not specified
        index = parentNode.children.length;
      } else {
        parentNode = parentNode || this.state.rootNode; // Defaults to rootNode if not specified
      }
      if (!ensureNodeInstance(parentNode)) {
        return false;
      }
      if (typeof index !== 'number') {
        index = parentNode.children.length;
      }

      // Assign parent
      newNodes.forEach(function (newNode) {
        newNode.parent = parentNode;
      });

      // Insert new child node at the specified index
      parentNode.children.splice.apply(parentNode.children, [index, 0].concat(newNodes));

      // Get the index of the first new node within the array of child nodes
      index = parentNode.children.indexOf(newNodes[0]);
      var deleteCount = parentNode.state.total;
      var nodes = (0, _flattree.flatten)(parentNode.children, {
        openNodes: this.state.openNodes
      });
      var rows = [];
      // Update rows
      rows.length = nodes.length;
      for (var i = 0; i < nodes.length; ++i) {
        var node = nodes[i];
        rows[i] = this.options.rowRenderer(node, this.options);
      }
      if (parentNode === this.state.rootNode) {
        this.nodes = nodes;
        this.rows = rows;
      } else {
        var parentOffset = this.nodes.indexOf(parentNode);
        if (parentOffset >= 0) {
          if (parentNode.state.open === true) {
            // Update nodes & rows
            this.nodes.splice.apply(this.nodes, [parentOffset + 1, deleteCount].concat(nodes));
            this.rows.splice.apply(this.rows, [parentOffset + 1, deleteCount].concat(rows));
          }

          // Update the row corresponding to the parent node
          this.rows[parentOffset] = this.options.rowRenderer(parentNode, this.options);
        }
      }

      // Update the lookup table with newly added nodes
      parentNode.children.slice(index).forEach(function (childNode) {
        _this3.flattenNode(childNode).forEach(function (node) {
          if (node.id !== undefined) {
            _this3.nodeTable.set(node.id, node);
          }
        });
      });

      // Update list
      this.update();
      return true;
    }

    // Adds a new child node to the end of the list of children of a specified parent node.
    // * If the parent is null or undefined, inserts the child at the specified index in the top-level.
    // * If the parent has children, the method adds the child as the last child.
    // * If the parent does not have children, the method adds the child to the parent.
    // @param {object} newNode The new child node.
    // @param {Node} parentNode The Node object that defines the parent node.
    // @return {boolean} Returns true on success, false otherwise.
  }, {
    key: "appendChildNode",
    value: function appendChildNode(newNode, parentNode) {
      // Defaults to rootNode if the parentNode is not specified
      parentNode = parentNode || this.state.rootNode;
      if (!ensureNodeInstance(parentNode)) {
        return false;
      }
      var index = parentNode.children.length;
      var newNodes = [].concat(newNode || []); // Ensure array
      return this.addChildNodes(newNodes, index, parentNode);
    }

    // Checks or unchecks a node.
    // @param {Node} node The Node object.
    // @param {boolean} [checked] Whether to check or uncheck the node. If not specified, it will toggle between checked and unchecked state.
    // @return {boolean} Returns true on success, false otherwise.
    // @example
    //
    // tree.checkNode(node); // toggle checked and unchecked state
    // tree.checkNode(node, true); // checked=true, indeterminate=false
    // tree.checkNode(node, false); // checked=false, indeterminate=false
    //
    // @doc
    //
    // state.checked | state.indeterminate | description
    // ------------- | ------------------- | -----------
    // false         | false               | The node and all of its children are unchecked.
    // true          | false               | The node and all of its children are checked.
    // true          | true                | The node will appear as indeterminate when the node is checked and some (but not all) of its children are checked.
  }, {
    key: "checkNode",
    value: function checkNode(node, checked) {
      if (!ensureNodeInstance(node)) {
        return false;
      }
      this.emit('willCheckNode', node);

      // Retrieve node index
      var nodeIndex = this.nodes.indexOf(node);
      if (nodeIndex < 0) {
        error('Invalid node index');
        return false;
      }
      if (checked === true) {
        node.state.checked = true;
        node.state.indeterminate = false;
      } else if (checked === false) {
        node.state.checked = false;
        node.state.indeterminate = false;
      } else {
        node.state.checked = !!node.state.checked;
        node.state.indeterminate = !!node.state.indeterminate;
        node.state.checked = node.state.checked && node.state.indeterminate || !node.state.checked;
        node.state.indeterminate = false;
      }
      var topmostNode = node;
      var updateChildNodes = function updateChildNodes(parentNode) {
        var childNode = parentNode.getFirstChild(); // Ignore parent node
        while (childNode) {
          // Update checked and indeterminate state
          childNode.state.checked = parentNode.state.checked;
          childNode.state.indeterminate = false;
          if (childNode.hasChildren()) {
            childNode = childNode.getFirstChild();
          } else {
            // Find the parent level
            while (childNode.getNextSibling() === null && childNode.parent !== parentNode) {
              // Use child-parent link to get to the parent level
              childNode = childNode.getParent();
            }

            // Get next sibling
            childNode = childNode.getNextSibling();
          }
        }
      };
      var updateParentNodes = function updateParentNodes(childNode) {
        var parentNode = childNode.parent;
        while (parentNode && parentNode.state.depth >= 0) {
          topmostNode = parentNode;
          var checkedCount = 0;
          var indeterminate = false;
          var len = parentNode.children ? parentNode.children.length : 0;
          for (var i = 0; i < len; ++i) {
            var _childNode = parentNode.children[i];
            indeterminate = indeterminate || !!_childNode.state.indeterminate;
            if (_childNode.state.checked) {
              checkedCount++;
            }
          }
          if (checkedCount === 0) {
            parentNode.state.indeterminate = false;
            parentNode.state.checked = false;
          } else if (checkedCount > 0 && checkedCount < len || indeterminate) {
            parentNode.state.indeterminate = true;
            parentNode.state.checked = true;
          } else {
            parentNode.state.indeterminate = false;
            parentNode.state.checked = true;
          }
          parentNode = parentNode.parent;
        }
      };
      updateChildNodes(node);
      updateParentNodes(node);
      this.updateNode(topmostNode);

      // Emit a "checkNode" event
      this.emit('checkNode', node);
      return true;
    }

    // Clears the tree.
  }, {
    key: "clear",
    value: function clear() {
      if (this.clusterize) {
        this.clusterize.clear();
      }
      this.nodeTable.clear();
      this.nodes = [];
      this.rows = [];
      this.state.openNodes = [];
      this.state.rootNode = createRootNode(this.state.rootNode);
      this.state.selectedNode = null;
    }

    // Closes a node to hide its children.
    // @param {Node} node The Node object.
    // @param {object} [options] The options object.
    // @param {boolean} [options.silent] Pass true to prevent "closeNode" and "selectNode" events from being triggered.
    // @return {boolean} Returns true on success, false otherwise.
  }, {
    key: "closeNode",
    value: function closeNode(node, options) {
      var _this4 = this;
      var _options = _objectSpread({}, options),
        _options$async = _options.async,
        async = _options$async === void 0 ? false : _options$async,
        _options$asyncCallbac = _options.asyncCallback,
        asyncCallback = _options$asyncCallbac === void 0 ? noop : _options$asyncCallbac,
        _options$silent = _options.silent,
        silent = _options$silent === void 0 ? false : _options$silent;
      if (!ensureNodeInstance(node)) {
        return false;
      }
      this.emit('willCloseNode', node);

      // Cannot close the root node
      if (node === this.state.rootNode) {
        error('Cannot close the root node');
        return false;
      }

      // Retrieve node index
      var nodeIndex = this.nodes.indexOf(node);
      if (nodeIndex < 0) {
        error('Invalid node index');
        return false;
      }

      // Check if the closeNode action can be performed
      if (this.state.openNodes.indexOf(node) < 0) {
        return false;
      }

      // Toggle the collapsing state
      node.state.collapsing = true;
      // Update the row corresponding to the node
      this.rows[nodeIndex] = this.options.rowRenderer(node, this.options);
      // Update list
      this.update();
      var fn = function fn() {
        // Keep selected node unchanged if "node" is equal to "this.state.selectedNode"
        if (_this4.state.selectedNode && _this4.state.selectedNode !== node) {
          // row #0 - node.0         => parent node (total=4)
          // row #1   - node.0.0     => close this node; next selected node (total=2)
          // row #2       node.0.0.0 => selected node (total=0)
          // row #3       node.0.0.1
          // row #4     node.0.1
          var selectedIndex = _this4.nodes.indexOf(_this4.state.selectedNode);
          var _total = node.state.total;
          var rangeFrom = nodeIndex + 1;
          var rangeTo = nodeIndex + _total;
          if (rangeFrom <= selectedIndex && selectedIndex <= rangeTo) {
            _this4.selectNode(node, options);
          }
        }
        node.state.open = false; // Set the open state to false
        var openNodes = _this4.state.openNodes.filter(function (node) {
          return node.state.open;
        });
        _this4.state.openNodes = openNodes;

        // Subtract total from ancestor nodes
        var total = node.state.total;
        for (var p = node; p !== null; p = p.parent) {
          p.state.total = p.state.total - total;
        }

        // Update nodes & rows
        (0, _removeArrayItems["default"])(_this4.nodes, nodeIndex + 1, total);
        (0, _removeArrayItems["default"])(_this4.rows, nodeIndex + 1, total);

        // Toggle the collapsing state
        node.state.collapsing = false;
        // Update the row corresponding to the node
        _this4.rows[nodeIndex] = _this4.options.rowRenderer(node, _this4.options);

        // Update list
        _this4.update();
        if (!silent) {
          // Emit a "closeNode" event
          _this4.emit('closeNode', node);
        }
        if (typeof asyncCallback === 'function') {
          asyncCallback();
        }
      };
      if (async) {
        setTimeout(fn, 0);
      } else {
        fn();
      }
      return true;
    }

    // Filters nodes. Use a string or a function to test each node of the tree. Otherwise, it will render nothing after filtering (e.g. tree.filter(), tree.filter(null), tree.flter(0), tree.filter({}), etc.).
    // @param {string|function} predicate A keyword string, or a function to test each node of the tree. If the predicate is an empty string, all nodes will be filtered. If the predicate is a function, returns true to keep the node, false otherwise.
    // @param {object} [options] The options object.
    // @param {boolean} [options.caseSensitive] Case sensitive string comparison. Defaults to false. This option is only available for string comparison.
    // @param {boolean} [options.exactMatch] Exact string matching. Defaults to false. This option is only available for string comparison.
    // @param {string} [options.filterPath] Gets the value at path of Node object. Defaults to 'name'. This option is only available for string comparison.
    // @param {boolean} [options.includeAncestors] Whether to include ancestor nodes. Defaults to true.
    // @param {boolean} [options.includeDescendants] Whether to include descendant nodes. Defaults to true.
    // @example
    //
    // const filterOptions = {
    //     caseSensitive: false,
    //     exactMatch: false,
    //     filterPath: 'props.some.other.key',
    //     includeAncestors: true,
    //     includeDescendants: true
    // };
    // tree.filter('keyword', filterOptions);
    //
    // @example
    //
    // const filterOptions = {
    //     includeAncestors: true,
    //     includeDescendants: true
    // };
    // tree.filter(function(node) {
    //     const keyword = 'keyword';
    //     const filterText = node.name || '';
    //     return filterText.toLowerCase().indexOf(keyword) >= 0;
    // }, filterOptions);
  }, {
    key: "filter",
    value: function filter(predicate, options) {
      options = _objectSpread({
        caseSensitive: false,
        exactMatch: false,
        filterPath: 'name',
        includeAncestors: true,
        includeDescendants: true
      }, options);
      this.filtered = true;
      var rootNode = this.state.rootNode;
      var traverse = function traverse(node) {
        var filterNode = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
        if (!node || !node.children) {
          return false;
        }
        if (node === rootNode) {
          node.state.filtered = false;
        } else if (filterNode) {
          node.state.filtered = true;
        } else if (typeof predicate === 'string') {
          // string
          var filterText = (0, _utilities.get)(node, options.filterPath, '');
          if (Number.isFinite(filterText)) {
            filterText = String(filterText);
          }
          if (typeof filterText !== 'string') {
            filterText = '';
          }
          var keyword = predicate;
          if (!options.caseSensitive) {
            filterText = filterText.toLowerCase();
            keyword = keyword.toLowerCase();
          }
          node.state.filtered = options.exactMatch ? filterText === keyword : filterText.indexOf(keyword) >= 0;
        } else if (typeof predicate === 'function') {
          // function
          var callback = predicate;
          node.state.filtered = !!callback(node);
        } else {
          node.state.filtered = false;
        }
        if (options.includeDescendants) {
          filterNode = filterNode || node.state.filtered;
        }
        var filtered = false;
        for (var i = 0; i < node.children.length; ++i) {
          var childNode = node.children[i];
          if (!childNode) {
            continue;
          }
          if (traverse(childNode, filterNode)) {
            filtered = true;
          }
        }
        if (options.includeAncestors && filtered) {
          node.state.filtered = true;
        }
        return node.state.filtered;
      };
      traverse(rootNode);

      // Update rows
      this.rows.length = this.nodes.length;
      for (var i = 0; i < this.nodes.length; ++i) {
        var node = this.nodes[i];
        this.rows[i] = this.options.rowRenderer(node, this.options);
      }
      this.update();
    }

    // Flattens all child nodes of a parent node by performing full tree traversal using child-parent link.
    // No recursion or stack is involved.
    // @param {Node} parentNode The Node object that defines the parent node.
    // @return {array} Returns an array of Node objects containing all the child nodes of the parent node.
  }, {
    key: "flattenChildNodes",
    value: function flattenChildNodes(parentNode) {
      // Defaults to rootNode if the parentNode is not specified
      parentNode = parentNode || this.state.rootNode;
      if (!ensureNodeInstance(parentNode)) {
        return [];
      }
      var list = [];
      var node = parentNode.getFirstChild(); // Ignore parent node
      while (node) {
        list.push(node);
        if (node.hasChildren()) {
          node = node.getFirstChild();
        } else {
          // Find the parent level
          while (node.getNextSibling() === null && node.parent !== parentNode) {
            // Use child-parent link to get to the parent level
            node = node.getParent();
          }

          // Get next sibling
          node = node.getNextSibling();
        }
      }
      return list;
    }

    // Flattens a node by performing full tree traversal using child-parent link.
    // No recursion or stack is involved.
    // @param {Node} node The Node object.
    // @return {array} Returns a flattened list of Node objects.
  }, {
    key: "flattenNode",
    value: function flattenNode(node) {
      if (!ensureNodeInstance(node)) {
        return [];
      }
      return [node].concat(this.flattenChildNodes(node));
    }

    // Gets a list of child nodes.
    // @param {Node} [parentNode] The Node object that defines the parent node. If null or undefined, returns a list of top level nodes.
    // @return {array} Returns an array of Node objects containing all the child nodes of the parent node.
  }, {
    key: "getChildNodes",
    value: function getChildNodes(parentNode) {
      // Defaults to rootNode if the parentNode is not specified
      parentNode = parentNode || this.state.rootNode;
      if (!ensureNodeInstance(parentNode)) {
        return [];
      }
      return parentNode.children;
    }

    // Gets a node by its unique id. This assumes that you have given the nodes in the data a unique id.
    // @param {string|number} id An unique node id. A null value will be returned if the id doesn't match.
    // @return {Node} Returns a node the matches the id, null otherwise.
  }, {
    key: "getNodeById",
    value: function getNodeById(id) {
      var node = this.nodeTable.get(id);
      if (!node) {
        // Find the first node that matches the id
        node = this.nodes.filter(function (node) {
          return node.id === id;
        })[0];
        if (!node) {
          return null;
        }
        this.nodeTable.set(node.id, node);
      }
      return node;
    }

    // Returns the node at the specified point. If the specified point is outside the visible bounds or either coordinate is negative, the result is null.
    // @param {number} x A horizontal position within the current viewport.
    // @param {number} y A vertical position within the current viewport.
    // @return {Node} The Node object under the given point.
  }, {
    key: "getNodeFromPoint",
    value: function getNodeFromPoint(x, y) {
      var el = document.elementFromPoint(x, y);
      while (el && el.parentElement !== this.contentElement) {
        el = el.parentElement;
      }
      if (!el) {
        return null;
      }
      var id = el.getAttribute(this.options.nodeIdAttr);
      var node = this.getNodeById(id);
      return node;
    }

    // Gets an array of open nodes.
    // @return {array} Returns an array of Node objects containing open nodes.
  }, {
    key: "getOpenNodes",
    value: function getOpenNodes() {
      // returns a shallow copy of an array into a new array object.
      return this.state.openNodes.slice();
    }

    // Gets the root node.
    // @return {Node} Returns the root node, or null if empty.
  }, {
    key: "getRootNode",
    value: function getRootNode() {
      return this.state.rootNode;
    }

    // Gets the selected node.
    // @return {Node} Returns the selected node, or null if not selected.
  }, {
    key: "getSelectedNode",
    value: function getSelectedNode() {
      return this.state.selectedNode;
    }

    // Gets the index of the selected node.
    // @return {number} Returns the index of the selected node, or -1 if not selected.
  }, {
    key: "getSelectedIndex",
    value: function getSelectedIndex() {
      return this.nodes.indexOf(this.state.selectedNode);
    }

    // Inserts the specified node after the reference node.
    // @param {object} newNode The new sibling node.
    // @param {Node} referenceNode The Node object that defines the reference node.
    // @return {boolean} Returns true on success, false otherwise.
  }, {
    key: "insertNodeAfter",
    value: function insertNodeAfter(newNode, referenceNode) {
      if (!ensureNodeInstance(referenceNode)) {
        return false;
      }
      var parentNode = referenceNode.getParent();
      var index = parentNode.children.indexOf(referenceNode) + 1;
      var newNodes = [].concat(newNode || []); // Ensure array

      return this.addChildNodes(newNodes, index, parentNode);
    }

    // Inserts the specified node before the reference node.
    // @param {object} newNode The new sibling node.
    // @param {Node} referenceNode The Node object that defines the reference node.
    // @return {boolean} Returns true on success, false otherwise.
  }, {
    key: "insertNodeBefore",
    value: function insertNodeBefore(newNode, referenceNode) {
      if (!ensureNodeInstance(referenceNode)) {
        return false;
      }
      var parentNode = referenceNode.getParent();
      var index = parentNode.children.indexOf(referenceNode);
      var newNodes = [].concat(newNode || []); // Ensure array

      return this.addChildNodes(newNodes, index, parentNode);
    }

    // Loads data in the tree.
    // @param {object|array} data The data is an object or array of objects that defines the node.
  }, {
    key: "loadData",
    value: function loadData() {
      var _this5 = this;
      var data = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      this.nodes = (0, _flattree.flatten)(data, {
        openAllNodes: this.options.autoOpen
      });

      // Clear lookup table
      this.nodeTable.clear();
      this.state.openNodes = this.nodes.filter(function (node) {
        return node.state.open;
      });
      this.state.selectedNode = null;
      var rootNode = function () {
        var node = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
        // Finding the root node
        while (node && node.parent !== null) {
          node = node.parent;
        }
        return node;
      }(this.nodes.length > 0 ? this.nodes[0] : null);
      this.state.rootNode = rootNode || createRootNode(this.state.rootNode); // Create a new root node if rootNode is null

      // Update the lookup table with newly added nodes
      this.flattenChildNodes(this.state.rootNode).forEach(function (node) {
        if (node.id !== undefined) {
          _this5.nodeTable.set(node.id, node);
        }
      });

      // Update rows
      this.rows.length = this.nodes.length;
      for (var i = 0; i < this.nodes.length; ++i) {
        var node = this.nodes[i];
        this.rows[i] = this.options.rowRenderer(node, this.options);
      }

      // Update list
      this.update();
    }

    // Moves a node from its current position to the new position.
    // @param {Node} node The Node object.
    // @param {Node} parentNode The Node object that defines the parent node.
    // @param {number} [index] The 0-based index of where to insert the child node.
    // @return {boolean} Returns true on success, false otherwise.
  }, {
    key: "moveNodeTo",
    value: function moveNodeTo(node, parentNode, index) {
      if (!ensureNodeInstance(node) || !ensureNodeInstance(parentNode)) {
        return false;
      }
      for (var p = parentNode; p !== null; p = p.parent) {
        if (p === node) {
          error("Cannot move an ancestor node (id=".concat(node.id, ") to the specified parent node (id=").concat(parentNode.id, ")."));
          return false;
        }
      }
      return this.removeNode(node) && this.addChildNodes(node, index, parentNode);
    }

    // Opens a node to display its children.
    // @param {Node} node The Node object.
    // @param {object} [options] The options object.
    // @param {boolean} [options.silent] Pass true to prevent "openNode" event from being triggered.
    // @return {boolean} Returns true on success, false otherwise.
  }, {
    key: "openNode",
    value: function openNode(node, options) {
      var _this6 = this;
      var _options2 = _objectSpread({}, options),
        _options2$async = _options2.async,
        async = _options2$async === void 0 ? false : _options2$async,
        _options2$asyncCallba = _options2.asyncCallback,
        asyncCallback = _options2$asyncCallba === void 0 ? noop : _options2$asyncCallba,
        _options2$silent = _options2.silent,
        silent = _options2$silent === void 0 ? false : _options2$silent;
      if (!ensureNodeInstance(node)) {
        return false;
      }
      if (!this.nodeTable.has(node.id)) {
        error('Cannot open node with the given node id:', node.id);
        return false;
      }

      // Check if the openNode action can be performed
      if (this.state.openNodes.indexOf(node) >= 0) {
        return false;
      }
      this.emit('willOpenNode', node);

      // Retrieve node index
      var nodeIndex = this.nodes.indexOf(node);
      var fn = function fn() {
        node.state.open = true;
        if (_this6.state.openNodes.indexOf(node) < 0) {
          // the most recently used items first
          _this6.state.openNodes = [node].concat(_this6.state.openNodes);
        }
        var nodes = (0, _flattree.flatten)(node.children, {
          openNodes: _this6.state.openNodes
        });

        // Add all child nodes to the lookup table if the first child does not exist in the lookup table
        if (nodes.length > 0 && !_this6.nodeTable.get(nodes[0])) {
          nodes.forEach(function (node) {
            if (node.id !== undefined) {
              _this6.nodeTable.set(node.id, node);
            }
          });
        }

        // Toggle the expanding state
        node.state.expanding = false;
        if (nodeIndex >= 0) {
          var rows = [];
          // Update rows
          rows.length = nodes.length;
          for (var i = 0; i < nodes.length; ++i) {
            var _node = nodes[i];
            rows[i] = _this6.options.rowRenderer(_node, _this6.options);
          }

          // Update nodes & rows
          _this6.nodes.splice.apply(_this6.nodes, [nodeIndex + 1, 0].concat(nodes));
          _this6.rows.splice.apply(_this6.rows, [nodeIndex + 1, 0].concat(rows));

          // Update the row corresponding to the node
          _this6.rows[nodeIndex] = _this6.options.rowRenderer(node, _this6.options);

          // Update list
          _this6.update();
        }
        if (!silent) {
          // Emit a "openNode" event
          _this6.emit('openNode', node);
        }
        if (typeof asyncCallback === 'function') {
          asyncCallback();
        }
      };
      if (nodeIndex < 0) {
        // Toggle the expanding state
        node.state.expanding = true;
        if (async) {
          setTimeout(fn, 0);
        } else {
          fn();
        }
        return true;
      }
      var shouldLoadNodes = typeof this.options.shouldLoadNodes === 'function' ? !!this.options.shouldLoadNodes(node) : !node.hasChildren() && node.loadOnDemand;
      if (shouldLoadNodes) {
        if (typeof this.options.loadNodes !== 'function') {
          return false;
        }

        // Reentrancy not allowed
        if (node.state.loading === true) {
          return false;
        }

        // Toggle the loading state
        node.state.loading = true;
        // Update the row corresponding to the node
        this.rows[nodeIndex] = this.options.rowRenderer(node, this.options);
        // Update list
        this.update();

        // Do a setTimeout to prevent the CPU intensive task
        setTimeout(function () {
          _this6.options.loadNodes(node, function (err, nodes) {
            var done = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : noop;
            nodes = (0, _ensureArray["default"])(nodes);
            var currentNodeIndex = _this6.nodes.indexOf(node);
            if (nodes.length === 0 && currentNodeIndex >= 0) {
              node.state.open = true;
              if (_this6.state.openNodes.indexOf(node) < 0) {
                // the most recently used items first
                _this6.state.openNodes = [node].concat(_this6.state.openNodes);
              }
            }
            if (err || nodes.length === 0) {
              // Toggle the loading state
              node.state.loading = false;
              // Update the row corresponding to the node
              _this6.rows[currentNodeIndex] = _this6.options.rowRenderer(node, _this6.options);
              // Update list
              _this6.update();
              if (typeof done === 'function') {
                done();
              }
              return;
            }
            _this6.addChildNodes(nodes, node);

            // Ensure the node has children to prevent infinite loop
            if (node.hasChildren()) {
              // Call openNode again
              _this6.openNode(node, _objectSpread(_objectSpread({}, options), {}, {
                async: true,
                asyncCallback: function asyncCallback() {
                  // Toggle the loading state
                  node.state.loading = false;
                  var openedNodeIndex = _this6.nodes.indexOf(node);
                  // Update the row corresponding to the node
                  _this6.rows[openedNodeIndex] = _this6.options.rowRenderer(node, _this6.options);
                  // Update list
                  _this6.update();
                  if (typeof done === 'function') {
                    done();
                  }
                }
              }));
            } else {
              // Toggle the loading state
              node.state.loading = false;
              // Update the row corresponding to the node
              _this6.rows[currentNodeIndex] = _this6.options.rowRenderer(node, _this6.options);
              // Update list
              _this6.update();
              if (typeof done === 'function') {
                done();
              }
            }
          });
        }, 0);
        return true;
      }

      // Toggle the expanding state
      node.state.expanding = true;

      // Update the row corresponding to the node
      this.rows[nodeIndex] = this.options.rowRenderer(node, this.options);
      // Update list
      this.update();
      if (async) {
        setTimeout(fn, 0);
      } else {
        fn();
      }
      return true;
    }

    // Removes all child nodes from a parent node.
    // @param {Node} parentNode The Node object that defines the parent node.
    // @param {object} [options] The options object.
    // @param {boolean} [options.silent] Pass true to prevent "selectNode" event from being triggered.
    // @return {boolean} Returns true on success, false otherwise.
  }, {
    key: "removeChildNodes",
    value: function removeChildNodes(parentNode, options) {
      var _this7 = this;
      if (!ensureNodeInstance(parentNode)) {
        return false;
      }
      if (parentNode.children.length === 0) {
        return false;
      }
      if (parentNode === this.state.rootNode) {
        this.clear();
        return true;
      }
      var parentNodeIndex = this.nodes.indexOf(parentNode);

      // Update selected node
      if (parentNodeIndex >= 0 && this.state.selectedNode) {
        // row #0 - node.0         => parent node (total=4)
        // row #1   - node.0.0
        // row #2       node.0.0.0 => current selected node
        // row #3       node.0.0.1
        // row #4     node.0.1
        var selectedIndex = this.nodes.indexOf(this.state.selectedNode);
        var rangeFrom = parentNodeIndex + 1;
        var rangeTo = parentNodeIndex + parentNode.state.total;
        if (rangeFrom <= selectedIndex && selectedIndex <= rangeTo) {
          if (parentNode === this.state.rootNode) {
            this.selectNode(null, options);
          } else {
            this.selectNode(parentNode, options);
          }
        }
      }

      // Get the nodes being removed
      var removedNodes = this.flattenChildNodes(parentNode);

      // Get the number of nodes to be removed
      var deleteCount = parentNode.state.total;

      // Subtract the deleteCount for all ancestors (parent, grandparent, etc.) of the current node
      for (var p = parentNode; p !== null; p = p.parent) {
        p.state.total = p.state.total - deleteCount;
      }

      // Update parent node
      parentNode.children = [];
      if (parentNode !== this.state.rootNode) {
        parentNode.state.open = parentNode.state.open && parentNode.children.length > 0;
      }
      if (parentNodeIndex >= 0) {
        // Update nodes & rows
        (0, _removeArrayItems["default"])(this.nodes, parentNodeIndex + 1, deleteCount);
        (0, _removeArrayItems["default"])(this.rows, parentNodeIndex + 1, deleteCount);

        // Update the row corresponding to the parent node
        this.rows[parentNodeIndex] = this.options.rowRenderer(parentNode, this.options);
      }
      {
        // Update open nodes and lookup table
        this.state.openNodes = this.state.openNodes.filter(function (node) {
          return removedNodes.indexOf(node) < 0 && node.state.open;
        });
        removedNodes.forEach(function (node) {
          _this7.nodeTable.unset(node.id);
        });
      }

      // Update list
      this.update();
      return true;
    }

    // Removes a node and all of its child nodes.
    // @param {Node} node The Node object.
    // @param {object} [options] The options object.
    // @param {boolean} [options.silent] Pass true to prevent "selectNode" event from being triggered.
    // @return {boolean} Returns true on success, false otherwise.
  }, {
    key: "removeNode",
    value: function removeNode(node, options) {
      var _this8 = this;
      if (!ensureNodeInstance(node)) {
        return false;
      }
      var parentNode = node.parent;
      if (!parentNode) {
        return false;
      }

      // Retrieve node index
      var nodeIndex = this.nodes.indexOf(node);
      var parentNodeIndex = this.nodes.indexOf(parentNode);

      // Update selected node
      if (nodeIndex >= 0 && this.state.selectedNode) {
        // row #0 - node.0         => parent node (total=4)
        // row #1   - node.0.0     => remove this node (total=2)
        // row #2       node.0.0.0 => current selected node (total=0)
        // row #3       node.0.0.1
        // row #4     node.0.1     => next selected node (total=0)
        var selectedIndex = this.nodes.indexOf(this.state.selectedNode);
        var rangeFrom = nodeIndex;
        var rangeTo = nodeIndex + node.state.total + 1;
        if (rangeFrom <= selectedIndex && selectedIndex <= rangeTo) {
          // Change the selected node in the following order:
          // 1. next sibling node
          // 2. previous sibling node
          // 3. parent node
          var selectedNode = node.getNextSibling() || node.getPreviousSibling() || node.getParent();
          if (selectedNode === this.state.rootNode) {
            this.selectNode(null, options);
          } else {
            this.selectNode(selectedNode, options);
          }
        }
      }

      // Get the nodes being removed
      var removedNodes = this.flattenNode(node);

      // Get the number of nodes to be removed
      var deleteCount = node.state.total + 1;

      // Subtract the deleteCount for all ancestors (parent, grandparent, etc.) of the current node
      for (var p = parentNode; p !== null; p = p.parent) {
        p.state.total = p.state.total - deleteCount;
      }

      // Update parent node
      (0, _removeArrayItems["default"])(parentNode.children, parentNode.children.indexOf(node), 1);
      if (parentNode !== this.state.rootNode) {
        parentNode.state.open = parentNode.state.open && parentNode.children.length > 0;
      }
      if (nodeIndex >= 0) {
        // Update nodes & rows
        (0, _removeArrayItems["default"])(this.nodes, nodeIndex, deleteCount);
        (0, _removeArrayItems["default"])(this.rows, nodeIndex, deleteCount);
      }

      // Update the row corresponding to the parent node
      if (parentNodeIndex >= 0) {
        this.rows[parentNodeIndex] = this.options.rowRenderer(parentNode, this.options);
      }
      {
        // Update open nodes and lookup table
        this.state.openNodes = this.state.openNodes.filter(function (node) {
          return removedNodes.indexOf(node) < 0 && node.state.open;
        });
        removedNodes.forEach(function (node) {
          _this8.nodeTable.unset(node.id);
        });
      }

      // Update list
      this.update();
      return true;
    }

    // Sets the current scroll position to this node.
    // @param {Node} node The Node object.
    // @return {boolean} Returns true on success, false otherwise.
  }, {
    key: "scrollToNode",
    value: function scrollToNode(node) {
      if (!ensureNodeInstance(node)) {
        return false;
      }

      // Retrieve node index
      var nodeIndex = this.nodes.indexOf(node);
      if (nodeIndex < 0) {
        return false;
      }
      if (!this.contentElement) {
        return false;
      }

      // Scroll to a desired position
      var prefix = 'infinite-tree-';
      var firstChild = this.contentElement.firstChild;
      while (firstChild) {
        var className = firstChild.className || '';
        if (className.indexOf(prefix + 'extra-row') < 0 && firstChild.offsetHeight > 0) {
          break;
        }
        firstChild = firstChild.nextSibling;
      }
      // If all items in the list is the same height, it can be calculated by nodeIndex * height.
      var itemHeight = firstChild && firstChild.getBoundingClientRect().height || 0;
      if (itemHeight > 0) {
        this.scrollTop(nodeIndex * itemHeight);
      }

      // Find the absolute position of the node
      var nodeSelector = "[".concat(this.options.nodeIdAttr, "=\"").concat(node.id, "\"]");
      var nodeEl = this.contentElement.querySelector(nodeSelector);
      if (nodeEl) {
        this.scrollTop(nodeEl.offsetTop);
      }
      return true;
    }

    // Gets (or sets) the current vertical position of the scroll bar.
    // @param {number} [value] If the value is specified, indicates the new position to set the scroll bar to.
    // @return {number} Returns the vertical scroll position.
  }, {
    key: "scrollTop",
    value: function scrollTop(value) {
      if (!this.scrollElement) {
        return 0;
      }
      if (value !== undefined) {
        this.scrollElement.scrollTop = Number(value);
      }
      return this.scrollElement.scrollTop;
    }

    // Selects a node.
    // @param {Node} node The Node object. If null or undefined, deselects the current node.
    // @param {object} [options] The options object.
    // @param {boolean} [options.autoScroll] Pass true to automatically scroll to the selected node. Defaults to true.
    // @param {boolean} [options.silent] Pass true to prevent "selectNode" event from being triggered. Defaults to false.
    // @return {boolean} Returns true on success, false otherwise.
  }, {
    key: "selectNode",
    value: function selectNode() {
      var node = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      var options = arguments.length > 1 ? arguments[1] : undefined;
      var _this$options = this.options,
        selectable = _this$options.selectable,
        shouldSelectNode = _this$options.shouldSelectNode;
      var _options3 = _objectSpread({}, options),
        _options3$autoScroll = _options3.autoScroll,
        autoScroll = _options3$autoScroll === void 0 ? true : _options3$autoScroll,
        _options3$silent = _options3.silent,
        silent = _options3$silent === void 0 ? false : _options3$silent;
      this.emit('willSelectNode', node);
      if (!selectable) {
        return false;
      }
      if (typeof shouldSelectNode === 'function' && !shouldSelectNode(node)) {
        return false;
      }
      if (node === this.state.rootNode) {
        return false;
      }
      if (node === null) {
        // Deselect the current node
        if (this.state.selectedNode) {
          var selectedNode = this.state.selectedNode;
          var selectedIndex = this.nodes.indexOf(this.state.selectedNode);
          selectedNode.state.selected = false;
          this.rows[selectedIndex] = this.options.rowRenderer(selectedNode, this.options);
          this.state.selectedNode = null;

          // Update list
          this.update();
          if (!silent) {
            // Emit a "selectNode" event
            this.emit('selectNode', null);
          }
          return true;
        }
        return false;
      }
      if (!ensureNodeInstance(node)) {
        return false;
      }

      // Retrieve node index
      var nodeIndex = this.nodes.indexOf(node);
      if (nodeIndex < 0) {
        return false;
      }

      // Select this node
      if (this.state.selectedNode !== node) {
        node.state.selected = true;

        // Update the row corresponding to the node
        this.rows[nodeIndex] = this.options.rowRenderer(node, this.options);
      }

      // Deselect the current node
      if (this.state.selectedNode) {
        var _selectedNode = this.state.selectedNode;
        var _selectedIndex = this.nodes.indexOf(this.state.selectedNode);
        _selectedNode.state.selected = false;
        this.rows[_selectedIndex] = this.options.rowRenderer(_selectedNode, this.options);
      }
      if (this.state.selectedNode !== node) {
        this.state.selectedNode = node;
        if (!silent) {
          // Emit a "selectNode" event
          this.emit('selectNode', node);
        }
        if (autoScroll && this.scrollElement && this.contentElement) {
          var nodeSelector = "[".concat(this.options.nodeIdAttr, "=\"").concat(node.id, "\"]");
          var nodeEl = this.contentElement.querySelector(nodeSelector);
          if (nodeEl) {
            var offsetTop = nodeEl.offsetTop || 0;
            var itemHeight = nodeEl.getBoundingClientRect().height || 0;

            // Scroll Up
            if (offsetTop < this.scrollElement.scrollTop) {
              this.scrollElement.scrollTop = offsetTop;
            }

            // Scroll Down
            if (offsetTop + itemHeight >= this.scrollElement.scrollTop + this.scrollElement.clientHeight) {
              this.scrollElement.scrollTop += itemHeight;
            }
          }
        }
      } else {
        this.state.selectedNode = null;
        if (!silent) {
          // Emit a "selectNode" event
          this.emit('selectNode', null);
        }
      }

      // Update list
      this.update();
      return true;
    }

    // Swaps two nodes.
    // @param {Node} node1 The Node object.
    // @param {Node} node2 The Node object.
    // @return {boolean} Returns true on success, false otherwise.
  }, {
    key: "swapNodes",
    value: function swapNodes(node1, node2) {
      if (!ensureNodeInstance(node1) || !ensureNodeInstance(node1.parent)) {
        return false;
      }
      if (!ensureNodeInstance(node2) || !ensureNodeInstance(node2.parent)) {
        return false;
      }
      var parentNode1 = node1.parent;
      var parentNode2 = node2.parent;
      for (var p = parentNode1; p !== null; p = p.parent) {
        if (p === node2) {
          error('Cannot swap two nodes with one being an ancestor of the other.');
          return false;
        }
      }
      for (var _p = parentNode2; _p !== null; _p = _p.parent) {
        if (_p === node1) {
          error('Cannot swap two nodes with one being an ancestor of the other.');
          return false;
        }
      }
      var nodeIndex1 = parentNode1.children.indexOf(node1);
      var nodeIndex2 = parentNode2.children.indexOf(node2);
      return this.moveNodeTo(node1, parentNode2, nodeIndex2) && this.moveNodeTo(node2, parentNode1, nodeIndex1);
    }

    // Toggles a node to display or hide its children.
    // @param {Node} node The Node object.
    // @param {object} [options] The options object.
    // @param {boolean} [options.silent] Pass true to prevent "closeNode", "openNode", and "selectNode" events from being triggered.
    // @return {boolean} Returns true on success, false otherwise.
  }, {
    key: "toggleNode",
    value: function toggleNode(node, options) {
      if (!ensureNodeInstance(node)) {
        return false;
      }
      if (this.state.openNodes.indexOf(node) >= 0) {
        // Close node
        return this.closeNode(node, options);
      } else {
        // Open node
        return this.openNode(node, options);
      }
    }

    // Serializes the current state of a node to a JSON string.
    // @param {Node} node The Node object. If null, returns the whole tree.
    // @return {string} Returns a JSON string represented the tree.
  }, {
    key: "toString",
    value: function toString() {
      var node = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      var traverse = function traverse(node) {
        var s = '[';
        if (node && node.children) {
          var _loop = function _loop(i) {
            var list = [];
            s = s + '{';
            Object.keys(node).forEach(function (key) {
              var value = node[key];
              if (key === 'parent') {
                // ignore parent
                return;
              }
              if (key === 'children') {
                // traverse child nodes
                list.push('"' + key + '":' + traverse(node.children[i]));
                return;
              }
              if (typeof value === 'string' || _typeof(value) === 'object') {
                list.push('"' + key + '":' + JSON.stringify(value));
              } else {
                // primitive types
                list.push('"' + key + '":' + value);
              }
            });
            s = s + list.join(',');
            s = s + '}' + (i === node.children.length - 1 ? '' : ',');
          };
          for (var i = 0; i < node.children.length; ++i) {
            _loop(i);
          }
        }
        s = s + ']';
        return s;
      };
      if (!node) {
        node = this.state.rootNode;
      }
      return traverse(node);
    }

    // Unfilters nodes.
  }, {
    key: "unfilter",
    value: function unfilter() {
      this.filtered = false;
      var rootNode = this.state.rootNode;
      var traverse = function traverse(node) {
        if (!node) {
          return;
        }
        delete node.state.filtered;
        if (!node.children) {
          return;
        }
        for (var i = 0; i < node.children.length; ++i) {
          var childNode = node.children[i];
          if (!childNode) {
            continue;
          }
          traverse(childNode);
        }
      };
      traverse(rootNode);

      // Update rows
      this.rows.length = this.nodes.length;
      for (var i = 0; i < this.nodes.length; ++i) {
        var node = this.nodes[i];
        this.rows[i] = this.options.rowRenderer(node, this.options);
      }
      this.update();
    }

    // Updates the tree.
  }, {
    key: "update",
    value: function update() {
      // Emit a "contentWillUpdate" event
      this.emit('contentWillUpdate');
      if (this.clusterize) {
        // Update list
        var rows = this.rows.filter(function (row) {
          return !!row;
        });
        this.clusterize.update(rows);
      }

      // Emit a "contentWillUpdate" event
      this.emit('contentDidUpdate');
    }

    // Updates the data of a node.
    // @param {Node} node The Node object.
    // @param {object} data The data object.
    // @param {object} [options] The options object.
    // @param {boolean} [options.shallowRendering] True to render only the parent node, false to render the parent node and all expanded child nodes. Defaults to false.
  }, {
    key: "updateNode",
    value: function updateNode(node, data, options) {
      if (!ensureNodeInstance(node)) {
        return;
      }

      // Clone a new one
      data = _objectSpread({}, data);
      if (data.id !== undefined && data.id !== null) {
        this.nodeTable.unset(node.id);
        this.nodeTable.set(data.id, node);
        node.id = data.id;
      }

      // Ignore keys: id, children, parent, and state
      delete data.id;
      delete data.children;
      delete data.parent;
      delete data.state;
      node = (0, _extend["default"])(node, data);

      // Retrieve node index
      var nodeIndex = this.nodes.indexOf(node);
      if (nodeIndex >= 0) {
        var _options4 = _objectSpread({}, options),
          _options4$shallowRend = _options4.shallowRendering,
          shallowRendering = _options4$shallowRend === void 0 ? false : _options4$shallowRend;

        // Update the row corresponding to the node
        this.rows[nodeIndex] = this.options.rowRenderer(node, this.options);
        if (!shallowRendering) {
          var total = node.state.total;
          var rangeFrom = nodeIndex + 1;
          var rangeTo = nodeIndex + total;
          for (var index = rangeFrom; index <= rangeTo; ++index) {
            this.rows[index] = this.options.rowRenderer(this.nodes[index], this.options);
          }
        }

        // Update list
        this.update();
      }
    }
  }]);
}(_events["default"].EventEmitter);
var _default = exports["default"] = InfiniteTree;