"use strict";

/* eslint no-restricted-syntax: 0 */
var extend = function extend(target) {
  if (target === undefined || target === null) {
    throw new TypeError('Cannot convert undefined or null to object');
  }
  var output = Object(target);
  for (var index = 0; index < (arguments.length <= 1 ? 0 : arguments.length - 1); index++) {
    var source = index + 1 < 1 || arguments.length <= index + 1 ? undefined : arguments[index + 1];
    if (source !== undefined && source !== null) {
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          output[key] = source[key];
        }
      }
    }
  }
  return output;
};
module.exports = extend;