"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _events = require("events");
var _ensureArray = _interopRequireDefault(require("./ensure-array"));
var _browser = require("./browser");
var _dom = require("./dom");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var ie = (0, _browser.getIEVersion)();
var Clusterize = /*#__PURE__*/function (_EventEmitter) {
  function Clusterize(options) {
    var _this;
    _classCallCheck(this, Clusterize);
    _this = _callSuper(this, Clusterize);
    _defineProperty(_this, "options", {
      rowsInBlock: 50,
      blocksInCluster: 4,
      tag: null,
      emptyClass: '',
      emptyText: '',
      keepParity: true
    });
    _defineProperty(_this, "state", {
      lastClusterIndex: -1,
      itemHeight: 0,
      blockHeight: 0,
      clusterHeight: 0
    });
    _defineProperty(_this, "scrollElement", null);
    _defineProperty(_this, "contentElement", null);
    _defineProperty(_this, "rows", []);
    _defineProperty(_this, "cache", {});
    _defineProperty(_this, "scrollEventListener", function () {
      var debounce = null;
      return function () {
        var isMac = navigator.platform.toLowerCase().indexOf('mac') >= 0;
        if (isMac) {
          if (_this.contentElement.style.pointerEvents !== 'none') {
            _this.contentElement.style.pointerEvents = 'none';
          }
          if (debounce) {
            clearTimeout(debounce);
            debounce = null;
          }
          debounce = setTimeout(function () {
            debounce = null;
            _this.contentElement.style.pointerEvents = 'auto';
          }, 50);
        }
        var clusterIndex = _this.getCurrentClusterIndex();
        if (_this.state.lastClusterIndex !== clusterIndex) {
          _this.changeDOM();
        }
        _this.state.lastClusterIndex = clusterIndex;
      };
    }());
    _defineProperty(_this, "resizeEventListener", function () {
      var debounce = null;
      return function () {
        if (debounce) {
          clearTimeout(debounce);
          debounce = null;
        }
        debounce = setTimeout(function () {
          var prevItemHeight = _this.state.itemHeight;
          var current = _this.computeHeight();
          if (current.itemHeight > 0 && prevItemHeight !== current.itemHeight) {
            _this.state = _objectSpread(_objectSpread({}, _this.state), current);
            _this.update(_this.rows);
          }
        }, 100);
      };
    }());
    if (!(_this instanceof Clusterize)) {
      return _possibleConstructorReturn(_this, new Clusterize(options));
    }
    _this.options = Object.keys(_this.options).reduce(function (acc, key) {
      if (options[key] !== undefined) {
        acc[key] = options[key];
      } else {
        acc[key] = _this.options[key];
      }
      return acc;
    }, {});
    _this.scrollElement = options.scrollElement;
    _this.contentElement = options.contentElement;

    // Keep focus on the scrolling content
    if (!_this.contentElement.hasAttribute('tabindex')) {
      _this.contentElement.setAttribute('tabindex', 0);
    }
    if (Array.isArray(options.rows)) {
      _this.rows = options.rows;
    } else {
      _this.rows = [];
      var nodes = _this.contentElement.children;
      var length = nodes.length;
      for (var i = 0; i < length; ++i) {
        var node = nodes[i];
        _this.rows.push(node.outerHTML || '');
      }
    }

    // Remember scroll position
    var scrollTop = _this.scrollElement.scrollTop;
    _this.changeDOM();

    // Restore scroll position
    _this.scrollElement.scrollTop = scrollTop;
    (0, _dom.addEventListener)(_this.scrollElement, 'scroll', _this.scrollEventListener);
    (0, _dom.addEventListener)(window, 'resize', _this.resizeEventListener);
    return _this;
  }
  _inherits(Clusterize, _EventEmitter);
  return _createClass(Clusterize, [{
    key: "destroy",
    value: function destroy(clean) {
      (0, _dom.removeEventListener)(this.scrollElement, 'scroll', this.scrollEventListener);
      (0, _dom.removeEventListener)(window, 'resize', this.resizeEventListener);
      var rows = clean ? this.generateEmptyRow() : this.rows();
      this.setContent(rows.join(''));
    }
  }, {
    key: "update",
    value: function update(rows) {
      this.rows = (0, _ensureArray["default"])(rows);

      // Remember scroll position
      var scrollTop = this.scrollElement.scrollTop;
      if (this.rows.length * this.state.itemHeight < scrollTop) {
        this.scrollElement.scrollTop = 0;
        this.state.lastClusterIndex = 0;
      }
      this.changeDOM();

      // Restore scroll position
      this.scrollElement.scrollTop = scrollTop;
    }
  }, {
    key: "clear",
    value: function clear() {
      this.rows = [];
      this.update();
    }
  }, {
    key: "append",
    value: function append(rows) {
      rows = (0, _ensureArray["default"])(rows);
      if (!rows.length) {
        return;
      }
      this.rows = this.rows.concat(rows);
      this.changeDOM();
    }
  }, {
    key: "prepend",
    value: function prepend(rows) {
      rows = (0, _ensureArray["default"])(rows);
      if (!rows.length) {
        return;
      }
      this.rows = rows.concat(this.rows);
      this.changeDOM();
    }
  }, {
    key: "computeHeight",
    value: function computeHeight() {
      if (!this.rows.length) {
        return {
          clusterHeight: 0,
          blockHeight: this.state.blockHeight,
          itemHeight: this.state.itemHeight
        };
      } else {
        var nodes = this.contentElement.children;
        var node = nodes[Math.floor(nodes.length / 2)];
        var itemHeight = node.getBoundingClientRect().height;
        if (this.options.tag === 'tr' && (0, _dom.getElementStyle)(this.contentElement, 'borderCollapse') !== 'collapse') {
          itemHeight += parseInt((0, _dom.getElementStyle)(this.contentElement, 'borderSpacing'), 10) || 0;
        }
        if (this.options.tag !== 'tr') {
          var marginTop = parseInt((0, _dom.getElementStyle)(node, 'marginTop'), 10) || 0;
          var marginBottom = parseInt((0, _dom.getElementStyle)(node, 'marginBottom'), 10) || 0;
          itemHeight += Math.max(marginTop, marginBottom);
        }
        var blockHeight = itemHeight * this.options.rowsInBlock;
        var clusterHeight = blockHeight * this.options.blocksInCluster;
        return {
          itemHeight: itemHeight,
          blockHeight: blockHeight,
          clusterHeight: clusterHeight
        };
      }
    }
  }, {
    key: "getCurrentClusterIndex",
    value: function getCurrentClusterIndex() {
      var _this$state = this.state,
        blockHeight = _this$state.blockHeight,
        clusterHeight = _this$state.clusterHeight;
      if (!blockHeight || !clusterHeight) {
        return 0;
      }
      return Math.floor(this.scrollElement.scrollTop / (clusterHeight - blockHeight)) || 0;
    }
  }, {
    key: "generateEmptyRow",
    value: function generateEmptyRow() {
      var _this$options = this.options,
        tag = _this$options.tag,
        emptyText = _this$options.emptyText,
        emptyClass = _this$options.emptyClass;
      if (!tag || !emptyText) {
        return [];
      }
      var emptyRow = document.createElement(tag);
      emptyRow.className = emptyClass;
      if (tag === 'tr') {
        var td = document.createElement('td');
        td.colSpan = 100;
        td.appendChild(document.createTextNode(emptyText));
        emptyRow.appendChild(td);
      } else {
        emptyRow.appendChild(document.createTextNode(emptyText));
      }
      return [emptyRow.outerHTML];
    }
  }, {
    key: "renderExtraTag",
    value: function renderExtraTag(className, height) {
      var tag = document.createElement(this.options.tag);
      var prefix = 'infinite-tree-';
      tag.className = [prefix + 'extra-row', prefix + className].join(' ');
      if (height) {
        tag.style.height = height + 'px';
      }
      return tag.outerHTML;
    }
  }, {
    key: "changeDOM",
    value: function changeDOM() {
      if (!this.state.clusterHeight && this.rows.length > 0) {
        if (ie && ie <= 9 && !this.options.tag) {
          this.options.tag = this.rows[0].match(/<([^>\s/]*)/)[1].toLowerCase();
        }
        if (this.contentElement.children.length <= 1) {
          this.cache.content = this.setContent(this.rows[0] + this.rows[0] + this.rows[0]);
        }
        if (!this.options.tag) {
          this.options.tag = this.contentElement.children[0].tagName.toLowerCase();
        }
        this.state = _objectSpread(_objectSpread({}, this.state), this.computeHeight());
      }
      var topOffset = 0;
      var bottomOffset = 0;
      var rows = [];
      if (this.rows.length < this.options.rowsInBlock) {
        rows = this.rows.length > 0 ? this.rows : this.generateEmptyRow();
      } else {
        var rowsInCluster = this.options.rowsInBlock * this.options.blocksInCluster;
        var clusterIndex = this.getCurrentClusterIndex();
        var visibleStart = Math.max((rowsInCluster - this.options.rowsInBlock) * clusterIndex, 0);
        var visibleEnd = visibleStart + rowsInCluster;
        topOffset = Math.max(visibleStart * this.state.itemHeight, 0);
        bottomOffset = Math.max((this.rows.length - visibleEnd) * this.state.itemHeight, 0);

        // Returns a shallow copy of the rows selected from `visibleStart` to `visibleEnd` (`visibleEnd` not included).
        rows = this.rows.slice(visibleStart, visibleEnd);
      }
      var content = rows.join('');
      var contentChanged = this.checkChanges('content', content);
      var topOffsetChanged = this.checkChanges('top', topOffset);
      var bottomOffsetChanged = this.checkChanges('bottom', bottomOffset);
      if (contentChanged || topOffsetChanged) {
        var layout = [];
        if (topOffset > 0) {
          if (this.options.keepParity) {
            layout.push(this.renderExtraTag('keep-parity'));
          }
          layout.push(this.renderExtraTag('top-space', topOffset));
        }
        layout.push(content);
        if (bottomOffset > 0) {
          layout.push(this.renderExtraTag('bottom-space', bottomOffset));
        }
        this.emit('clusterWillChange');
        this.setContent(layout.join(''));
        this.emit('clusterDidChange');
      } else if (bottomOffsetChanged) {
        this.contentElement.lastChild.style.height = bottomOffset + 'px';
      }
    }
  }, {
    key: "setContent",
    value: function setContent(content) {
      // For IE 9 and older versions
      if (ie && ie <= 9 && this.options.tag === 'tr') {
        var div = document.createElement('div');
        div.innerHTML = "<table><tbody>".concat(content, "</tbody></table>");
        var lastChild = this.contentElement.lastChild;
        while (lastChild) {
          this.contentElement.removeChild(lastChild);
          lastChild = this.contentElement.lastChild;
        }
        var rowsNodes = this.getChildNodes(div.firstChild.firstChild);
        while (rowsNodes.length) {
          this.contentElement.appendChild(rowsNodes.shift());
        }
      } else {
        this.contentElement.innerHTML = content;
      }
    }
  }, {
    key: "getChildNodes",
    value: function getChildNodes(tag) {
      var childNodes = tag.children;
      var nodes = [];
      var length = childNodes.length;
      for (var i = 0; i < length; i++) {
        nodes.push(childNodes[i]);
      }
      return nodes;
    }
  }, {
    key: "checkChanges",
    value: function checkChanges(type, value) {
      var changed = value !== this.cache[type];
      this.cache[type] = value;
      return changed;
    }
  }]);
}(_events.EventEmitter);
var _default = exports["default"] = Clusterize;