'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };

var _escapeHtml = require('escape-html');

var _escapeHtml2 = _interopRequireDefault(_escapeHtml);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// https://www.w3.org/TR/html5/syntax.html#void-elements
// Void elements only have a start tag; end tags must not be specified for void elements.
var voidElements = ['area', 'base', 'br', 'col', 'embed', 'hr', 'img', 'input', 'keygen', 'link', 'meta', 'param', 'source', 'track', 'wbr'];

// @param {string} [tag] The tag name. Defaults to 'div'.
// @param {object} attrs HTML attributes.
// @param {string} [text] The content string.
module.exports = function (tag, attrs, text) {
    if ((typeof tag === 'undefined' ? 'undefined' : _typeof(tag)) === 'object') {
        text = attrs;
        attrs = tag;
        tag = 'div';
    }

    var voidElement = voidElements.indexOf(('' + tag).toLowerCase()) >= 0;
    var html = '<' + tag;

    attrs = _extends({}, attrs);
    Object.keys(attrs).forEach(function (name) {
        var value = attrs[name];
        if (typeof value === 'string') {
            value = (0, _escapeHtml2.default)('' + value);
            html += ' ' + name + '="' + value + '"';
        } else if (!!value) {
            html += ' ' + name;
        }
    });

    if (voidElement) {
        html += '>';
    } else if (text !== undefined) {
        html += '>' + text + '</' + tag + '>';
    } else {
        html += '/>';
    }

    return html;
};