<?php

/*
 * This file is part of the Sylius package.
 *
 * (c) Sylius Sp. z o.o.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace Sylius\Bundle\AdminBundle\Form\Type;

use Sylius\Bundle\ShippingBundle\Form\Type\ShippingMethodRuleType as BaseShippingMethodRuleType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class ShippingMethodRuleType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->add('type', HiddenType::class);
    }

    public function buildView(FormView $view, FormInterface $form, array $options): void
    {
        $view->vars['types'] = $options['types'];
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefault('types', []);
    }

    public function getParent(): string
    {
        return BaseShippingMethodRuleType::class;
    }

    public function getBlockPrefix(): string
    {
        return 'sylius_admin_shipping_method_rule';
    }
}
