<?php

/*
 * This file is part of the Sylius package.
 *
 * (c) Sylius Sp. z o.o.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace Sylius\Bundle\AdminBundle\Form\Type;

use Sylius\Bundle\OrderBundle\Form\Type\OrderType as BaseOrderType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class OrderType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('shippingAddress', AddressType::class, [
                'add_build_address_form_subscriber' => $options['add_build_address_form_subscriber'],
            ])
            ->add('billingAddress', AddressType::class, [
                'add_build_address_form_subscriber' => $options['add_build_address_form_subscriber'],
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        parent::configureOptions($resolver);

        $resolver->setDefaults(['add_build_address_form_subscriber' => true]);
    }

    public function getParent(): string
    {
        return BaseOrderType::class;
    }

    public function getBlockPrefix(): string
    {
        return 'sylius_admin_order';
    }
}
